# Known Answer Test Files
Known answer tests are used to verify correctness of certain functionality within s2n. The fixed test vectors in the KAT
files are compared against calculated values during unit tests. Currently, all KATs are applicable only to
post-quantum/hybrid functionality.

## NIST KATs
KATs of the form `${KEM}_r${N}.kat` (e.g. `sike_r2.kat`) are provided by NIST as part of their
[post-quantum cryptography standardization effort](https://csrc.nist.gov/projects/post-quantum-cryptography).
These KATs are used to verify that the `generate_keypair`, `encapsulate`, and `decapsulate` functions for each PQ-KEM
are correct. The `seed` value for each test vector is used as entropy to initialize the DRBG during the unit test
so that the test can replicate the deterministic randomness used to generate the `pk`, `sk`, `ct`, and `ss` values.
All values are represented as hex-encoded strings.

All NIST KATs were generated with a DRBG in AES 256 counter mode, no derivation function, no prediction resistance.

## Hybrid KATs
KATs of the form `hybrid_echde_${KEM}_r${N}.kat` (e.g. `hybrid_echde_sike_r2.kat`) are used to verify that client and
server are correctly generating, parsing, and processing the server key exchange message, client key exchange message,
and master secret for hybrid TLS 1.2. The formats of the key exchange messages are given in the [hybrid TLS 1.2 draft
spec](https://tools.ietf.org/html/draft-campagna-tls-bike-sike-hybrid). To summarize, the server key exchange message is
the concatenation: `ServerECDHEParams || ServerPQKemParams || Signature` and the client key exchange message is the
concatenation: `ClientECDHEParams || ClientPQKemParams`. The `expected_server_key_exchange_message` and 
`expected_client_key_exchange_message` conform to those formats. The messages were generated by providing the `seed`
value as entropy to initialize the DRBG to a known, fixed state, then generating the `expected_server_key_exchange_message`,
followed by the `expected_client_key_exchange_message`. The message are hex-encoded bytes, exactly as they would appear
over the wire during a TLS 1.2 handshake (the `Record Header` and `Handshake Header` bytes are omitted). Additionally,
for all KATs:
* The DRBG was set to AES 256 counter mode, no derivation function (`S2N_AES_256_CTR_NO_DF_PR`)
* The named curve was `secp256r1`
* The hash algorithm was `SHA384`
* The signature algorithm was RSA

## Hybrid PRF KAT
The `hybrid_prf.kat` KAT is used to verify correctness of the TLS 1.2 hybrid PRF responsible for deriving the master
secret. The test vectors were generated from an independent implementation of the hybrid PRF. The values
`premaster_kem_secret_length` and `client_key_exchange_message_length` must be defined in the KAT file, since they vary
based on the PQ-KEM. The length must be specified as a base 10 integer. The lengths for all other elements do not vary
and are defined in the source test files. The values for `premaster_classic_secret`, `premaster_kem_secret`,
`client_random`, `server_random`, `client_key_exchange_message`, and `master_secret` are represented as hex-encoded
strings.

## TLS 1.3 Server Hybrid Key Share KAT
The `tls13_server_hybrid_key_share_recv.kat` KAT is used to verify correctness of the TLS 1.3 client functionality for
receiving PQ hybrid key shares from the server. The values for `pq_private_key` and `pq_shared_secret` were taken from
the first entry of the NIST KAT files. The value for `server_key_share_payload` is hex-encoded bytes, as they would
appear over the wire, of the key shares extension received by the client in the `ServerHello` (the first four bytes of
a typical key share extension are omitted - the payload begins with the two-byte identifier for the named KEM group).
 