# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccessPolicy(msrest.serialization.Model):
    """An Access policy.

    :ivar start: The date-time the policy is active.
    :vartype start: str
    :ivar expiry: The date-time the policy expires.
    :vartype expiry: str
    :ivar permission: The permissions for the ACL policy.
    :vartype permission: str
    """

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'str'},
        'expiry': {'key': 'Expiry', 'type': 'str'},
        'permission': {'key': 'Permission', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword start: The date-time the policy is active.
        :paramtype start: str
        :keyword expiry: The date-time the policy expires.
        :paramtype expiry: str
        :keyword permission: The permissions for the ACL policy.
        :paramtype permission: str
        """
        super(AccessPolicy, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.expiry = kwargs.get('expiry', None)
        self.permission = kwargs.get('permission', None)


class ClearRange(msrest.serialization.Model):
    """ClearRange.

    All required parameters must be populated in order to send to Azure.

    :ivar start: Required.
    :vartype start: long
    :ivar end: Required.
    :vartype end: long
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'long', 'xml': {'name': 'Start'}},
        'end': {'key': 'End', 'type': 'long', 'xml': {'name': 'End'}},
    }
    _xml_map = {
        'name': 'ClearRange'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword start: Required.
        :paramtype start: long
        :keyword end: Required.
        :paramtype end: long
        """
        super(ClearRange, self).__init__(**kwargs)
        self.start = kwargs['start']
        self.end = kwargs['end']


class CopyFileSmbInfo(msrest.serialization.Model):
    """Parameter group.

    :ivar file_attributes: Specifies either the option to copy file attributes from a source
     file(source) to a target file or a list of attributes to set on a target file.
    :vartype file_attributes: str
    :ivar file_creation_time: Specifies either the option to copy file creation time from a source
     file(source) to a target file or a time value in ISO 8601 format to set as creation time on a
     target file.
    :vartype file_creation_time: str
    :ivar file_last_write_time: Specifies either the option to copy file last write time from a
     source file(source) to a target file or a time value in ISO 8601 format to set as last write
     time on a target file.
    :vartype file_last_write_time: str
    :ivar file_change_time: Specifies either the option to copy file last write time from a source
     file(source) to a target file or a time value in ISO 8601 format to set as last write time on a
     target file.
    :vartype file_change_time: str
    :ivar file_permission_copy_mode: Specifies the option to copy file security descriptor from
     source file or to set it using the value which is defined by the header value of
     x-ms-file-permission or x-ms-file-permission-key. Possible values include: "source",
     "override".
    :vartype file_permission_copy_mode: str or
     ~azure.storage.fileshare.models.PermissionCopyModeType
    :ivar ignore_read_only: Specifies the option to overwrite the target file if it already exists
     and has read-only attribute set.
    :vartype ignore_read_only: bool
    :ivar set_archive_attribute: Specifies the option to set archive attribute on a target file.
     True means archive attribute will be set on a target file despite attribute overrides or a
     source file state.
    :vartype set_archive_attribute: bool
    """

    _attribute_map = {
        'file_attributes': {'key': 'fileAttributes', 'type': 'str'},
        'file_creation_time': {'key': 'fileCreationTime', 'type': 'str'},
        'file_last_write_time': {'key': 'fileLastWriteTime', 'type': 'str'},
        'file_change_time': {'key': 'fileChangeTime', 'type': 'str'},
        'file_permission_copy_mode': {'key': 'filePermissionCopyMode', 'type': 'str'},
        'ignore_read_only': {'key': 'ignoreReadOnly', 'type': 'bool'},
        'set_archive_attribute': {'key': 'setArchiveAttribute', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword file_attributes: Specifies either the option to copy file attributes from a source
         file(source) to a target file or a list of attributes to set on a target file.
        :paramtype file_attributes: str
        :keyword file_creation_time: Specifies either the option to copy file creation time from a
         source file(source) to a target file or a time value in ISO 8601 format to set as creation time
         on a target file.
        :paramtype file_creation_time: str
        :keyword file_last_write_time: Specifies either the option to copy file last write time from a
         source file(source) to a target file or a time value in ISO 8601 format to set as last write
         time on a target file.
        :paramtype file_last_write_time: str
        :keyword file_change_time: Specifies either the option to copy file last write time from a
         source file(source) to a target file or a time value in ISO 8601 format to set as last write
         time on a target file.
        :paramtype file_change_time: str
        :keyword file_permission_copy_mode: Specifies the option to copy file security descriptor from
         source file or to set it using the value which is defined by the header value of
         x-ms-file-permission or x-ms-file-permission-key. Possible values include: "source",
         "override".
        :paramtype file_permission_copy_mode: str or
         ~azure.storage.fileshare.models.PermissionCopyModeType
        :keyword ignore_read_only: Specifies the option to overwrite the target file if it already
         exists and has read-only attribute set.
        :paramtype ignore_read_only: bool
        :keyword set_archive_attribute: Specifies the option to set archive attribute on a target file.
         True means archive attribute will be set on a target file despite attribute overrides or a
         source file state.
        :paramtype set_archive_attribute: bool
        """
        super(CopyFileSmbInfo, self).__init__(**kwargs)
        self.file_attributes = kwargs.get('file_attributes', None)
        self.file_creation_time = kwargs.get('file_creation_time', None)
        self.file_last_write_time = kwargs.get('file_last_write_time', None)
        self.file_change_time = kwargs.get('file_change_time', None)
        self.file_permission_copy_mode = kwargs.get('file_permission_copy_mode', None)
        self.ignore_read_only = kwargs.get('ignore_read_only', None)
        self.set_archive_attribute = kwargs.get('set_archive_attribute', None)


class CorsRule(msrest.serialization.Model):
    """CORS is an HTTP feature that enables a web application running under one domain to access resources in another domain. Web browsers implement a security restriction known as same-origin policy that prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain (the origin domain) to call APIs in another domain.

    All required parameters must be populated in order to send to Azure.

    :ivar allowed_origins: Required. The origin domains that are permitted to make a request
     against the storage service via CORS. The origin domain is the domain from which the request
     originates. Note that the origin must be an exact case-sensitive match with the origin that the
     user age sends to the service. You can also use the wildcard character '*' to allow all origin
     domains to make requests via CORS.
    :vartype allowed_origins: str
    :ivar allowed_methods: Required. The methods (HTTP request verbs) that the origin domain may
     use for a CORS request. (comma separated).
    :vartype allowed_methods: str
    :ivar allowed_headers: Required. The request headers that the origin domain may specify on the
     CORS request.
    :vartype allowed_headers: str
    :ivar exposed_headers: Required. The response headers that may be sent in the response to the
     CORS request and exposed by the browser to the request issuer.
    :vartype exposed_headers: str
    :ivar max_age_in_seconds: Required. The maximum amount time that a browser should cache the
     preflight OPTIONS request.
    :vartype max_age_in_seconds: int
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'allowed_headers': {'required': True},
        'exposed_headers': {'required': True},
        'max_age_in_seconds': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'AllowedOrigins', 'type': 'str'},
        'allowed_methods': {'key': 'AllowedMethods', 'type': 'str'},
        'allowed_headers': {'key': 'AllowedHeaders', 'type': 'str'},
        'exposed_headers': {'key': 'ExposedHeaders', 'type': 'str'},
        'max_age_in_seconds': {'key': 'MaxAgeInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword allowed_origins: Required. The origin domains that are permitted to make a request
         against the storage service via CORS. The origin domain is the domain from which the request
         originates. Note that the origin must be an exact case-sensitive match with the origin that the
         user age sends to the service. You can also use the wildcard character '*' to allow all origin
         domains to make requests via CORS.
        :paramtype allowed_origins: str
        :keyword allowed_methods: Required. The methods (HTTP request verbs) that the origin domain may
         use for a CORS request. (comma separated).
        :paramtype allowed_methods: str
        :keyword allowed_headers: Required. The request headers that the origin domain may specify on
         the CORS request.
        :paramtype allowed_headers: str
        :keyword exposed_headers: Required. The response headers that may be sent in the response to
         the CORS request and exposed by the browser to the request issuer.
        :paramtype exposed_headers: str
        :keyword max_age_in_seconds: Required. The maximum amount time that a browser should cache the
         preflight OPTIONS request.
        :paramtype max_age_in_seconds: int
        """
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = kwargs['allowed_origins']
        self.allowed_methods = kwargs['allowed_methods']
        self.allowed_headers = kwargs['allowed_headers']
        self.exposed_headers = kwargs['exposed_headers']
        self.max_age_in_seconds = kwargs['max_age_in_seconds']


class DestinationLeaseAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :ivar destination_lease_id: Required if the destination file has an active infinite lease. The
     lease ID specified for this header must match the lease ID of the destination file. If the
     request does not include the lease ID or it is not valid, the operation fails with status code
     412 (Precondition Failed). If this header is specified and the destination file does not
     currently have an active lease, the operation will also fail with status code 412 (Precondition
     Failed).
    :vartype destination_lease_id: str
    """

    _attribute_map = {
        'destination_lease_id': {'key': 'destinationLeaseId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword destination_lease_id: Required if the destination file has an active infinite lease.
         The lease ID specified for this header must match the lease ID of the destination file. If the
         request does not include the lease ID or it is not valid, the operation fails with status code
         412 (Precondition Failed). If this header is specified and the destination file does not
         currently have an active lease, the operation will also fail with status code 412 (Precondition
         Failed).
        :paramtype destination_lease_id: str
        """
        super(DestinationLeaseAccessConditions, self).__init__(**kwargs)
        self.destination_lease_id = kwargs.get('destination_lease_id', None)


class DirectoryItem(msrest.serialization.Model):
    """A listed directory item.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar file_id:
    :vartype file_id: str
    :ivar properties: File properties.
    :vartype properties: ~azure.storage.fileshare.models.FileProperty
    :ivar attributes:
    :vartype attributes: str
    :ivar permission_key:
    :vartype permission_key: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'file_id': {'key': 'FileId', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': 'FileProperty'},
        'attributes': {'key': 'Attributes', 'type': 'str'},
        'permission_key': {'key': 'PermissionKey', 'type': 'str'},
    }
    _xml_map = {
        'name': 'Directory'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword file_id:
        :paramtype file_id: str
        :keyword properties: File properties.
        :paramtype properties: ~azure.storage.fileshare.models.FileProperty
        :keyword attributes:
        :paramtype attributes: str
        :keyword permission_key:
        :paramtype permission_key: str
        """
        super(DirectoryItem, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.file_id = kwargs.get('file_id', None)
        self.properties = kwargs.get('properties', None)
        self.attributes = kwargs.get('attributes', None)
        self.permission_key = kwargs.get('permission_key', None)


class FileHTTPHeaders(msrest.serialization.Model):
    """Parameter group.

    :ivar file_content_type: Sets the MIME content type of the file. The default type is
     'application/octet-stream'.
    :vartype file_content_type: str
    :ivar file_content_encoding: Specifies which content encodings have been applied to the file.
    :vartype file_content_encoding: str
    :ivar file_content_language: Specifies the natural languages used by this resource.
    :vartype file_content_language: str
    :ivar file_cache_control: Sets the file's cache control. The File service stores this value but
     does not use or modify it.
    :vartype file_cache_control: str
    :ivar file_content_md5: Sets the file's MD5 hash.
    :vartype file_content_md5: bytearray
    :ivar file_content_disposition: Sets the file's Content-Disposition header.
    :vartype file_content_disposition: str
    """

    _attribute_map = {
        'file_content_type': {'key': 'fileContentType', 'type': 'str'},
        'file_content_encoding': {'key': 'fileContentEncoding', 'type': 'str'},
        'file_content_language': {'key': 'fileContentLanguage', 'type': 'str'},
        'file_cache_control': {'key': 'fileCacheControl', 'type': 'str'},
        'file_content_md5': {'key': 'fileContentMD5', 'type': 'bytearray'},
        'file_content_disposition': {'key': 'fileContentDisposition', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword file_content_type: Sets the MIME content type of the file. The default type is
         'application/octet-stream'.
        :paramtype file_content_type: str
        :keyword file_content_encoding: Specifies which content encodings have been applied to the
         file.
        :paramtype file_content_encoding: str
        :keyword file_content_language: Specifies the natural languages used by this resource.
        :paramtype file_content_language: str
        :keyword file_cache_control: Sets the file's cache control. The File service stores this value
         but does not use or modify it.
        :paramtype file_cache_control: str
        :keyword file_content_md5: Sets the file's MD5 hash.
        :paramtype file_content_md5: bytearray
        :keyword file_content_disposition: Sets the file's Content-Disposition header.
        :paramtype file_content_disposition: str
        """
        super(FileHTTPHeaders, self).__init__(**kwargs)
        self.file_content_type = kwargs.get('file_content_type', None)
        self.file_content_encoding = kwargs.get('file_content_encoding', None)
        self.file_content_language = kwargs.get('file_content_language', None)
        self.file_cache_control = kwargs.get('file_cache_control', None)
        self.file_content_md5 = kwargs.get('file_content_md5', None)
        self.file_content_disposition = kwargs.get('file_content_disposition', None)


class FileItem(msrest.serialization.Model):
    """A listed file item.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar file_id:
    :vartype file_id: str
    :ivar properties: Required. File properties.
    :vartype properties: ~azure.storage.fileshare.models.FileProperty
    :ivar attributes:
    :vartype attributes: str
    :ivar permission_key:
    :vartype permission_key: str
    """

    _validation = {
        'name': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'file_id': {'key': 'FileId', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': 'FileProperty'},
        'attributes': {'key': 'Attributes', 'type': 'str'},
        'permission_key': {'key': 'PermissionKey', 'type': 'str'},
    }
    _xml_map = {
        'name': 'File'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword file_id:
        :paramtype file_id: str
        :keyword properties: Required. File properties.
        :paramtype properties: ~azure.storage.fileshare.models.FileProperty
        :keyword attributes:
        :paramtype attributes: str
        :keyword permission_key:
        :paramtype permission_key: str
        """
        super(FileItem, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.file_id = kwargs.get('file_id', None)
        self.properties = kwargs['properties']
        self.attributes = kwargs.get('attributes', None)
        self.permission_key = kwargs.get('permission_key', None)


class FileProperty(msrest.serialization.Model):
    """File properties.

    All required parameters must be populated in order to send to Azure.

    :ivar content_length: Required. Content length of the file. This value may not be up-to-date
     since an SMB client may have modified the file locally. The value of Content-Length may not
     reflect that fact until the handle is closed or the op-lock is broken. To retrieve current
     property values, call Get File Properties.
    :vartype content_length: long
    :ivar creation_time:
    :vartype creation_time: ~datetime.datetime
    :ivar last_access_time:
    :vartype last_access_time: ~datetime.datetime
    :ivar last_write_time:
    :vartype last_write_time: ~datetime.datetime
    :ivar change_time:
    :vartype change_time: ~datetime.datetime
    :ivar last_modified:
    :vartype last_modified: ~datetime.datetime
    :ivar etag:
    :vartype etag: str
    """

    _validation = {
        'content_length': {'required': True},
    }

    _attribute_map = {
        'content_length': {'key': 'Content-Length', 'type': 'long'},
        'creation_time': {'key': 'CreationTime', 'type': 'iso-8601'},
        'last_access_time': {'key': 'LastAccessTime', 'type': 'iso-8601'},
        'last_write_time': {'key': 'LastWriteTime', 'type': 'iso-8601'},
        'change_time': {'key': 'ChangeTime', 'type': 'iso-8601'},
        'last_modified': {'key': 'Last-Modified', 'type': 'rfc-1123'},
        'etag': {'key': 'Etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword content_length: Required. Content length of the file. This value may not be up-to-date
         since an SMB client may have modified the file locally. The value of Content-Length may not
         reflect that fact until the handle is closed or the op-lock is broken. To retrieve current
         property values, call Get File Properties.
        :paramtype content_length: long
        :keyword creation_time:
        :paramtype creation_time: ~datetime.datetime
        :keyword last_access_time:
        :paramtype last_access_time: ~datetime.datetime
        :keyword last_write_time:
        :paramtype last_write_time: ~datetime.datetime
        :keyword change_time:
        :paramtype change_time: ~datetime.datetime
        :keyword last_modified:
        :paramtype last_modified: ~datetime.datetime
        :keyword etag:
        :paramtype etag: str
        """
        super(FileProperty, self).__init__(**kwargs)
        self.content_length = kwargs['content_length']
        self.creation_time = kwargs.get('creation_time', None)
        self.last_access_time = kwargs.get('last_access_time', None)
        self.last_write_time = kwargs.get('last_write_time', None)
        self.change_time = kwargs.get('change_time', None)
        self.last_modified = kwargs.get('last_modified', None)
        self.etag = kwargs.get('etag', None)


class FileRange(msrest.serialization.Model):
    """An Azure Storage file range.

    All required parameters must be populated in order to send to Azure.

    :ivar start: Required. Start of the range.
    :vartype start: long
    :ivar end: Required. End of the range.
    :vartype end: long
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'long'},
        'end': {'key': 'End', 'type': 'long'},
    }
    _xml_map = {
        'name': 'Range'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword start: Required. Start of the range.
        :paramtype start: long
        :keyword end: Required. End of the range.
        :paramtype end: long
        """
        super(FileRange, self).__init__(**kwargs)
        self.start = kwargs['start']
        self.end = kwargs['end']


class FilesAndDirectoriesListSegment(msrest.serialization.Model):
    """Abstract for entries that can be listed from Directory.

    All required parameters must be populated in order to send to Azure.

    :ivar directory_items: Required.
    :vartype directory_items: list[~azure.storage.fileshare.models.DirectoryItem]
    :ivar file_items: Required.
    :vartype file_items: list[~azure.storage.fileshare.models.FileItem]
    """

    _validation = {
        'directory_items': {'required': True},
        'file_items': {'required': True},
    }

    _attribute_map = {
        'directory_items': {'key': 'DirectoryItems', 'type': '[DirectoryItem]'},
        'file_items': {'key': 'FileItems', 'type': '[FileItem]'},
    }
    _xml_map = {
        'name': 'Entries'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword directory_items: Required.
        :paramtype directory_items: list[~azure.storage.fileshare.models.DirectoryItem]
        :keyword file_items: Required.
        :paramtype file_items: list[~azure.storage.fileshare.models.FileItem]
        """
        super(FilesAndDirectoriesListSegment, self).__init__(**kwargs)
        self.directory_items = kwargs['directory_items']
        self.file_items = kwargs['file_items']


class HandleItem(msrest.serialization.Model):
    """A listed Azure Storage handle item.

    All required parameters must be populated in order to send to Azure.

    :ivar handle_id: Required. XSMB service handle ID.
    :vartype handle_id: str
    :ivar path: Required. File or directory name including full path starting from share root.
    :vartype path: str
    :ivar file_id: Required. FileId uniquely identifies the file or directory.
    :vartype file_id: str
    :ivar parent_id: ParentId uniquely identifies the parent directory of the object.
    :vartype parent_id: str
    :ivar session_id: Required. SMB session ID in context of which the file handle was opened.
    :vartype session_id: str
    :ivar client_ip: Required. Client IP that opened the handle.
    :vartype client_ip: str
    :ivar open_time: Required. Time when the session that previously opened the handle has last
     been reconnected. (UTC).
    :vartype open_time: ~datetime.datetime
    :ivar last_reconnect_time: Time handle was last connected to (UTC).
    :vartype last_reconnect_time: ~datetime.datetime
    """

    _validation = {
        'handle_id': {'required': True},
        'path': {'required': True},
        'file_id': {'required': True},
        'session_id': {'required': True},
        'client_ip': {'required': True},
        'open_time': {'required': True},
    }

    _attribute_map = {
        'handle_id': {'key': 'HandleId', 'type': 'str'},
        'path': {'key': 'Path', 'type': 'str'},
        'file_id': {'key': 'FileId', 'type': 'str'},
        'parent_id': {'key': 'ParentId', 'type': 'str'},
        'session_id': {'key': 'SessionId', 'type': 'str'},
        'client_ip': {'key': 'ClientIp', 'type': 'str'},
        'open_time': {'key': 'OpenTime', 'type': 'rfc-1123'},
        'last_reconnect_time': {'key': 'LastReconnectTime', 'type': 'rfc-1123'},
    }
    _xml_map = {
        'name': 'Handle'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword handle_id: Required. XSMB service handle ID.
        :paramtype handle_id: str
        :keyword path: Required. File or directory name including full path starting from share root.
        :paramtype path: str
        :keyword file_id: Required. FileId uniquely identifies the file or directory.
        :paramtype file_id: str
        :keyword parent_id: ParentId uniquely identifies the parent directory of the object.
        :paramtype parent_id: str
        :keyword session_id: Required. SMB session ID in context of which the file handle was opened.
        :paramtype session_id: str
        :keyword client_ip: Required. Client IP that opened the handle.
        :paramtype client_ip: str
        :keyword open_time: Required. Time when the session that previously opened the handle has last
         been reconnected. (UTC).
        :paramtype open_time: ~datetime.datetime
        :keyword last_reconnect_time: Time handle was last connected to (UTC).
        :paramtype last_reconnect_time: ~datetime.datetime
        """
        super(HandleItem, self).__init__(**kwargs)
        self.handle_id = kwargs['handle_id']
        self.path = kwargs['path']
        self.file_id = kwargs['file_id']
        self.parent_id = kwargs.get('parent_id', None)
        self.session_id = kwargs['session_id']
        self.client_ip = kwargs['client_ip']
        self.open_time = kwargs['open_time']
        self.last_reconnect_time = kwargs.get('last_reconnect_time', None)


class LeaseAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :ivar lease_id: If specified, the operation only succeeds if the resource's lease is active and
     matches this ID.
    :vartype lease_id: str
    """

    _attribute_map = {
        'lease_id': {'key': 'leaseId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword lease_id: If specified, the operation only succeeds if the resource's lease is active
         and matches this ID.
        :paramtype lease_id: str
        """
        super(LeaseAccessConditions, self).__init__(**kwargs)
        self.lease_id = kwargs.get('lease_id', None)


class ListFilesAndDirectoriesSegmentResponse(msrest.serialization.Model):
    """An enumeration of directories and files.

    All required parameters must be populated in order to send to Azure.

    :ivar service_endpoint: Required.
    :vartype service_endpoint: str
    :ivar share_name: Required.
    :vartype share_name: str
    :ivar share_snapshot:
    :vartype share_snapshot: str
    :ivar directory_path: Required.
    :vartype directory_path: str
    :ivar prefix: Required.
    :vartype prefix: str
    :ivar marker:
    :vartype marker: str
    :ivar max_results:
    :vartype max_results: int
    :ivar segment: Required. Abstract for entries that can be listed from Directory.
    :vartype segment: ~azure.storage.fileshare.models.FilesAndDirectoriesListSegment
    :ivar next_marker: Required.
    :vartype next_marker: str
    :ivar directory_id:
    :vartype directory_id: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'share_name': {'required': True},
        'directory_path': {'required': True},
        'prefix': {'required': True},
        'segment': {'required': True},
        'next_marker': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'attr': True}},
        'share_name': {'key': 'ShareName', 'type': 'str', 'xml': {'attr': True}},
        'share_snapshot': {'key': 'ShareSnapshot', 'type': 'str', 'xml': {'attr': True}},
        'directory_path': {'key': 'DirectoryPath', 'type': 'str', 'xml': {'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str'},
        'marker': {'key': 'Marker', 'type': 'str'},
        'max_results': {'key': 'MaxResults', 'type': 'int'},
        'segment': {'key': 'Segment', 'type': 'FilesAndDirectoriesListSegment'},
        'next_marker': {'key': 'NextMarker', 'type': 'str'},
        'directory_id': {'key': 'DirectoryId', 'type': 'str'},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword service_endpoint: Required.
        :paramtype service_endpoint: str
        :keyword share_name: Required.
        :paramtype share_name: str
        :keyword share_snapshot:
        :paramtype share_snapshot: str
        :keyword directory_path: Required.
        :paramtype directory_path: str
        :keyword prefix: Required.
        :paramtype prefix: str
        :keyword marker:
        :paramtype marker: str
        :keyword max_results:
        :paramtype max_results: int
        :keyword segment: Required. Abstract for entries that can be listed from Directory.
        :paramtype segment: ~azure.storage.fileshare.models.FilesAndDirectoriesListSegment
        :keyword next_marker: Required.
        :paramtype next_marker: str
        :keyword directory_id:
        :paramtype directory_id: str
        """
        super(ListFilesAndDirectoriesSegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs['service_endpoint']
        self.share_name = kwargs['share_name']
        self.share_snapshot = kwargs.get('share_snapshot', None)
        self.directory_path = kwargs['directory_path']
        self.prefix = kwargs['prefix']
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs.get('max_results', None)
        self.segment = kwargs['segment']
        self.next_marker = kwargs['next_marker']
        self.directory_id = kwargs.get('directory_id', None)


class ListHandlesResponse(msrest.serialization.Model):
    """An enumeration of handles.

    All required parameters must be populated in order to send to Azure.

    :ivar handle_list:
    :vartype handle_list: list[~azure.storage.fileshare.models.HandleItem]
    :ivar next_marker: Required.
    :vartype next_marker: str
    """

    _validation = {
        'next_marker': {'required': True},
    }

    _attribute_map = {
        'handle_list': {'key': 'HandleList', 'type': '[HandleItem]', 'xml': {'name': 'Entries', 'wrapped': True, 'itemsName': 'Handle'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str'},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword handle_list:
        :paramtype handle_list: list[~azure.storage.fileshare.models.HandleItem]
        :keyword next_marker: Required.
        :paramtype next_marker: str
        """
        super(ListHandlesResponse, self).__init__(**kwargs)
        self.handle_list = kwargs.get('handle_list', None)
        self.next_marker = kwargs['next_marker']


class ListSharesResponse(msrest.serialization.Model):
    """An enumeration of shares.

    All required parameters must be populated in order to send to Azure.

    :ivar service_endpoint: Required.
    :vartype service_endpoint: str
    :ivar prefix:
    :vartype prefix: str
    :ivar marker:
    :vartype marker: str
    :ivar max_results:
    :vartype max_results: int
    :ivar share_items:
    :vartype share_items: list[~azure.storage.fileshare.models.ShareItemInternal]
    :ivar next_marker: Required.
    :vartype next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'next_marker': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str'},
        'marker': {'key': 'Marker', 'type': 'str'},
        'max_results': {'key': 'MaxResults', 'type': 'int'},
        'share_items': {'key': 'ShareItems', 'type': '[ShareItemInternal]', 'xml': {'name': 'Shares', 'wrapped': True, 'itemsName': 'Share'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str'},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword service_endpoint: Required.
        :paramtype service_endpoint: str
        :keyword prefix:
        :paramtype prefix: str
        :keyword marker:
        :paramtype marker: str
        :keyword max_results:
        :paramtype max_results: int
        :keyword share_items:
        :paramtype share_items: list[~azure.storage.fileshare.models.ShareItemInternal]
        :keyword next_marker: Required.
        :paramtype next_marker: str
        """
        super(ListSharesResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs['service_endpoint']
        self.prefix = kwargs.get('prefix', None)
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs.get('max_results', None)
        self.share_items = kwargs.get('share_items', None)
        self.next_marker = kwargs['next_marker']


class Metrics(msrest.serialization.Model):
    """Storage Analytics metrics for file service.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Required. The version of Storage Analytics to configure.
    :vartype version: str
    :ivar enabled: Required. Indicates whether metrics are enabled for the File service.
    :vartype enabled: bool
    :ivar include_apis: Indicates whether metrics should generate summary statistics for called API
     operations.
    :vartype include_apis: bool
    :ivar retention_policy: The retention policy.
    :vartype retention_policy: ~azure.storage.fileshare.models.RetentionPolicy
    """

    _validation = {
        'version': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str'},
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'include_apis': {'key': 'IncludeAPIs', 'type': 'bool'},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword version: Required. The version of Storage Analytics to configure.
        :paramtype version: str
        :keyword enabled: Required. Indicates whether metrics are enabled for the File service.
        :paramtype enabled: bool
        :keyword include_apis: Indicates whether metrics should generate summary statistics for called
         API operations.
        :paramtype include_apis: bool
        :keyword retention_policy: The retention policy.
        :paramtype retention_policy: ~azure.storage.fileshare.models.RetentionPolicy
        """
        super(Metrics, self).__init__(**kwargs)
        self.version = kwargs['version']
        self.enabled = kwargs['enabled']
        self.include_apis = kwargs.get('include_apis', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class RetentionPolicy(msrest.serialization.Model):
    """The retention policy.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Required. Indicates whether a retention policy is enabled for the File service.
     If false, metrics data is retained, and the user is responsible for deleting it.
    :vartype enabled: bool
    :ivar days: Indicates the number of days that metrics data should be retained. All data older
     than this value will be deleted. Metrics data is deleted on a best-effort basis after the
     retention period expires.
    :vartype days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'maximum': 365, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'days': {'key': 'Days', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword enabled: Required. Indicates whether a retention policy is enabled for the File
         service. If false, metrics data is retained, and the user is responsible for deleting it.
        :paramtype enabled: bool
        :keyword days: Indicates the number of days that metrics data should be retained. All data
         older than this value will be deleted. Metrics data is deleted on a best-effort basis after the
         retention period expires.
        :paramtype days: int
        """
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.days = kwargs.get('days', None)


class ShareFileRangeList(msrest.serialization.Model):
    """The list of file ranges.

    :ivar ranges:
    :vartype ranges: list[~azure.storage.fileshare.models.FileRange]
    :ivar clear_ranges:
    :vartype clear_ranges: list[~azure.storage.fileshare.models.ClearRange]
    """

    _attribute_map = {
        'ranges': {'key': 'Ranges', 'type': '[FileRange]'},
        'clear_ranges': {'key': 'ClearRanges', 'type': '[ClearRange]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword ranges:
        :paramtype ranges: list[~azure.storage.fileshare.models.FileRange]
        :keyword clear_ranges:
        :paramtype clear_ranges: list[~azure.storage.fileshare.models.ClearRange]
        """
        super(ShareFileRangeList, self).__init__(**kwargs)
        self.ranges = kwargs.get('ranges', None)
        self.clear_ranges = kwargs.get('clear_ranges', None)


class ShareItemInternal(msrest.serialization.Model):
    """A listed Azure Storage share item.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar snapshot:
    :vartype snapshot: str
    :ivar deleted:
    :vartype deleted: bool
    :ivar version:
    :vartype version: str
    :ivar properties: Required. Properties of a share.
    :vartype properties: ~azure.storage.fileshare.models.SharePropertiesInternal
    :ivar metadata: Dictionary of :code:`<string>`.
    :vartype metadata: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'snapshot': {'key': 'Snapshot', 'type': 'str'},
        'deleted': {'key': 'Deleted', 'type': 'bool'},
        'version': {'key': 'Version', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': 'SharePropertiesInternal'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }
    _xml_map = {
        'name': 'Share'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword snapshot:
        :paramtype snapshot: str
        :keyword deleted:
        :paramtype deleted: bool
        :keyword version:
        :paramtype version: str
        :keyword properties: Required. Properties of a share.
        :paramtype properties: ~azure.storage.fileshare.models.SharePropertiesInternal
        :keyword metadata: Dictionary of :code:`<string>`.
        :paramtype metadata: dict[str, str]
        """
        super(ShareItemInternal, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.snapshot = kwargs.get('snapshot', None)
        self.deleted = kwargs.get('deleted', None)
        self.version = kwargs.get('version', None)
        self.properties = kwargs['properties']
        self.metadata = kwargs.get('metadata', None)


class SharePermission(msrest.serialization.Model):
    """A permission (a security descriptor) at the share level.

    All required parameters must be populated in order to send to Azure.

    :ivar permission: Required. The permission in the Security Descriptor Definition Language
     (SDDL).
    :vartype permission: str
    """

    _validation = {
        'permission': {'required': True},
    }

    _attribute_map = {
        'permission': {'key': 'permission', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword permission: Required. The permission in the Security Descriptor Definition Language
         (SDDL).
        :paramtype permission: str
        """
        super(SharePermission, self).__init__(**kwargs)
        self.permission = kwargs['permission']


class SharePropertiesInternal(msrest.serialization.Model):
    """Properties of a share.

    All required parameters must be populated in order to send to Azure.

    :ivar last_modified: Required.
    :vartype last_modified: ~datetime.datetime
    :ivar etag: Required.
    :vartype etag: str
    :ivar quota: Required.
    :vartype quota: int
    :ivar provisioned_iops:
    :vartype provisioned_iops: int
    :ivar provisioned_ingress_m_bps:
    :vartype provisioned_ingress_m_bps: int
    :ivar provisioned_egress_m_bps:
    :vartype provisioned_egress_m_bps: int
    :ivar provisioned_bandwidth_mi_bps:
    :vartype provisioned_bandwidth_mi_bps: int
    :ivar next_allowed_quota_downgrade_time:
    :vartype next_allowed_quota_downgrade_time: ~datetime.datetime
    :ivar deleted_time:
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days:
    :vartype remaining_retention_days: int
    :ivar access_tier:
    :vartype access_tier: str
    :ivar access_tier_change_time:
    :vartype access_tier_change_time: ~datetime.datetime
    :ivar access_tier_transition_state:
    :vartype access_tier_transition_state: str
    :ivar lease_status: The current lease status of the share. Possible values include: "locked",
     "unlocked".
    :vartype lease_status: str or ~azure.storage.fileshare.models.LeaseStatusType
    :ivar lease_state: Lease state of the share. Possible values include: "available", "leased",
     "expired", "breaking", "broken".
    :vartype lease_state: str or ~azure.storage.fileshare.models.LeaseStateType
    :ivar lease_duration: When a share is leased, specifies whether the lease is of infinite or
     fixed duration. Possible values include: "infinite", "fixed".
    :vartype lease_duration: str or ~azure.storage.fileshare.models.LeaseDurationType
    :ivar enabled_protocols:
    :vartype enabled_protocols: str
    :ivar root_squash: Possible values include: "NoRootSquash", "RootSquash", "AllSquash".
    :vartype root_squash: str or ~azure.storage.fileshare.models.ShareRootSquash
    """

    _validation = {
        'last_modified': {'required': True},
        'etag': {'required': True},
        'quota': {'required': True},
    }

    _attribute_map = {
        'last_modified': {'key': 'Last-Modified', 'type': 'rfc-1123'},
        'etag': {'key': 'Etag', 'type': 'str'},
        'quota': {'key': 'Quota', 'type': 'int'},
        'provisioned_iops': {'key': 'ProvisionedIops', 'type': 'int'},
        'provisioned_ingress_m_bps': {'key': 'ProvisionedIngressMBps', 'type': 'int'},
        'provisioned_egress_m_bps': {'key': 'ProvisionedEgressMBps', 'type': 'int'},
        'provisioned_bandwidth_mi_bps': {'key': 'ProvisionedBandwidthMiBps', 'type': 'int'},
        'next_allowed_quota_downgrade_time': {'key': 'NextAllowedQuotaDowngradeTime', 'type': 'rfc-1123'},
        'deleted_time': {'key': 'DeletedTime', 'type': 'rfc-1123'},
        'remaining_retention_days': {'key': 'RemainingRetentionDays', 'type': 'int'},
        'access_tier': {'key': 'AccessTier', 'type': 'str'},
        'access_tier_change_time': {'key': 'AccessTierChangeTime', 'type': 'rfc-1123'},
        'access_tier_transition_state': {'key': 'AccessTierTransitionState', 'type': 'str'},
        'lease_status': {'key': 'LeaseStatus', 'type': 'str'},
        'lease_state': {'key': 'LeaseState', 'type': 'str'},
        'lease_duration': {'key': 'LeaseDuration', 'type': 'str'},
        'enabled_protocols': {'key': 'EnabledProtocols', 'type': 'str'},
        'root_squash': {'key': 'RootSquash', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword last_modified: Required.
        :paramtype last_modified: ~datetime.datetime
        :keyword etag: Required.
        :paramtype etag: str
        :keyword quota: Required.
        :paramtype quota: int
        :keyword provisioned_iops:
        :paramtype provisioned_iops: int
        :keyword provisioned_ingress_m_bps:
        :paramtype provisioned_ingress_m_bps: int
        :keyword provisioned_egress_m_bps:
        :paramtype provisioned_egress_m_bps: int
        :keyword provisioned_bandwidth_mi_bps:
        :paramtype provisioned_bandwidth_mi_bps: int
        :keyword next_allowed_quota_downgrade_time:
        :paramtype next_allowed_quota_downgrade_time: ~datetime.datetime
        :keyword deleted_time:
        :paramtype deleted_time: ~datetime.datetime
        :keyword remaining_retention_days:
        :paramtype remaining_retention_days: int
        :keyword access_tier:
        :paramtype access_tier: str
        :keyword access_tier_change_time:
        :paramtype access_tier_change_time: ~datetime.datetime
        :keyword access_tier_transition_state:
        :paramtype access_tier_transition_state: str
        :keyword lease_status: The current lease status of the share. Possible values include:
         "locked", "unlocked".
        :paramtype lease_status: str or ~azure.storage.fileshare.models.LeaseStatusType
        :keyword lease_state: Lease state of the share. Possible values include: "available", "leased",
         "expired", "breaking", "broken".
        :paramtype lease_state: str or ~azure.storage.fileshare.models.LeaseStateType
        :keyword lease_duration: When a share is leased, specifies whether the lease is of infinite or
         fixed duration. Possible values include: "infinite", "fixed".
        :paramtype lease_duration: str or ~azure.storage.fileshare.models.LeaseDurationType
        :keyword enabled_protocols:
        :paramtype enabled_protocols: str
        :keyword root_squash: Possible values include: "NoRootSquash", "RootSquash", "AllSquash".
        :paramtype root_squash: str or ~azure.storage.fileshare.models.ShareRootSquash
        """
        super(SharePropertiesInternal, self).__init__(**kwargs)
        self.last_modified = kwargs['last_modified']
        self.etag = kwargs['etag']
        self.quota = kwargs['quota']
        self.provisioned_iops = kwargs.get('provisioned_iops', None)
        self.provisioned_ingress_m_bps = kwargs.get('provisioned_ingress_m_bps', None)
        self.provisioned_egress_m_bps = kwargs.get('provisioned_egress_m_bps', None)
        self.provisioned_bandwidth_mi_bps = kwargs.get('provisioned_bandwidth_mi_bps', None)
        self.next_allowed_quota_downgrade_time = kwargs.get('next_allowed_quota_downgrade_time', None)
        self.deleted_time = kwargs.get('deleted_time', None)
        self.remaining_retention_days = kwargs.get('remaining_retention_days', None)
        self.access_tier = kwargs.get('access_tier', None)
        self.access_tier_change_time = kwargs.get('access_tier_change_time', None)
        self.access_tier_transition_state = kwargs.get('access_tier_transition_state', None)
        self.lease_status = kwargs.get('lease_status', None)
        self.lease_state = kwargs.get('lease_state', None)
        self.lease_duration = kwargs.get('lease_duration', None)
        self.enabled_protocols = kwargs.get('enabled_protocols', None)
        self.root_squash = kwargs.get('root_squash', None)


class ShareProtocolSettings(msrest.serialization.Model):
    """Protocol settings.

    :ivar smb: Settings for SMB protocol.
    :vartype smb: ~azure.storage.fileshare.models.ShareSmbSettings
    """

    _attribute_map = {
        'smb': {'key': 'Smb', 'type': 'ShareSmbSettings'},
    }
    _xml_map = {
        'name': 'ProtocolSettings'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword smb: Settings for SMB protocol.
        :paramtype smb: ~azure.storage.fileshare.models.ShareSmbSettings
        """
        super(ShareProtocolSettings, self).__init__(**kwargs)
        self.smb = kwargs.get('smb', None)


class ShareSmbSettings(msrest.serialization.Model):
    """Settings for SMB protocol.

    :ivar multichannel: Settings for SMB Multichannel.
    :vartype multichannel: ~azure.storage.fileshare.models.SmbMultichannel
    """

    _attribute_map = {
        'multichannel': {'key': 'Multichannel', 'type': 'SmbMultichannel'},
    }
    _xml_map = {
        'name': 'SMB'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword multichannel: Settings for SMB Multichannel.
        :paramtype multichannel: ~azure.storage.fileshare.models.SmbMultichannel
        """
        super(ShareSmbSettings, self).__init__(**kwargs)
        self.multichannel = kwargs.get('multichannel', None)


class ShareStats(msrest.serialization.Model):
    """Stats for the share.

    All required parameters must be populated in order to send to Azure.

    :ivar share_usage_bytes: Required. The approximate size of the data stored in bytes. Note that
     this value may not include all recently created or recently resized files.
    :vartype share_usage_bytes: int
    """

    _validation = {
        'share_usage_bytes': {'required': True},
    }

    _attribute_map = {
        'share_usage_bytes': {'key': 'ShareUsageBytes', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword share_usage_bytes: Required. The approximate size of the data stored in bytes. Note
         that this value may not include all recently created or recently resized files.
        :paramtype share_usage_bytes: int
        """
        super(ShareStats, self).__init__(**kwargs)
        self.share_usage_bytes = kwargs['share_usage_bytes']


class SignedIdentifier(msrest.serialization.Model):
    """Signed identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. A unique id.
    :vartype id: str
    :ivar access_policy: The access policy.
    :vartype access_policy: ~azure.storage.fileshare.models.AccessPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'access_policy': {'key': 'AccessPolicy', 'type': 'AccessPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. A unique id.
        :paramtype id: str
        :keyword access_policy: The access policy.
        :paramtype access_policy: ~azure.storage.fileshare.models.AccessPolicy
        """
        super(SignedIdentifier, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.access_policy = kwargs.get('access_policy', None)


class SmbMultichannel(msrest.serialization.Model):
    """Settings for SMB multichannel.

    :ivar enabled: If SMB multichannel is enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool'},
    }
    _xml_map = {
        'name': 'Multichannel'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword enabled: If SMB multichannel is enabled.
        :paramtype enabled: bool
        """
        super(SmbMultichannel, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class SourceLeaseAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :ivar source_lease_id: Required if the source file has an active infinite lease.
    :vartype source_lease_id: str
    """

    _attribute_map = {
        'source_lease_id': {'key': 'sourceLeaseId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword source_lease_id: Required if the source file has an active infinite lease.
        :paramtype source_lease_id: str
        """
        super(SourceLeaseAccessConditions, self).__init__(**kwargs)
        self.source_lease_id = kwargs.get('source_lease_id', None)


class SourceModifiedAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :ivar source_if_match_crc64: Specify the crc64 value to operate only on range with a matching
     crc64 checksum.
    :vartype source_if_match_crc64: bytearray
    :ivar source_if_none_match_crc64: Specify the crc64 value to operate only on range without a
     matching crc64 checksum.
    :vartype source_if_none_match_crc64: bytearray
    """

    _attribute_map = {
        'source_if_match_crc64': {'key': 'sourceIfMatchCrc64', 'type': 'bytearray'},
        'source_if_none_match_crc64': {'key': 'sourceIfNoneMatchCrc64', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword source_if_match_crc64: Specify the crc64 value to operate only on range with a
         matching crc64 checksum.
        :paramtype source_if_match_crc64: bytearray
        :keyword source_if_none_match_crc64: Specify the crc64 value to operate only on range without a
         matching crc64 checksum.
        :paramtype source_if_none_match_crc64: bytearray
        """
        super(SourceModifiedAccessConditions, self).__init__(**kwargs)
        self.source_if_match_crc64 = kwargs.get('source_if_match_crc64', None)
        self.source_if_none_match_crc64 = kwargs.get('source_if_none_match_crc64', None)


class StorageError(msrest.serialization.Model):
    """StorageError.

    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword message:
        :paramtype message: str
        """
        super(StorageError, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)


class StorageServiceProperties(msrest.serialization.Model):
    """Storage service properties.

    :ivar hour_metrics: A summary of request statistics grouped by API in hourly aggregates for
     files.
    :vartype hour_metrics: ~azure.storage.fileshare.models.Metrics
    :ivar minute_metrics: A summary of request statistics grouped by API in minute aggregates for
     files.
    :vartype minute_metrics: ~azure.storage.fileshare.models.Metrics
    :ivar cors: The set of CORS rules.
    :vartype cors: list[~azure.storage.fileshare.models.CorsRule]
    :ivar protocol: Protocol settings.
    :vartype protocol: ~azure.storage.fileshare.models.ShareProtocolSettings
    """

    _attribute_map = {
        'hour_metrics': {'key': 'HourMetrics', 'type': 'Metrics'},
        'minute_metrics': {'key': 'MinuteMetrics', 'type': 'Metrics'},
        'cors': {'key': 'Cors', 'type': '[CorsRule]', 'xml': {'wrapped': True}},
        'protocol': {'key': 'Protocol', 'type': 'ShareProtocolSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword hour_metrics: A summary of request statistics grouped by API in hourly aggregates for
         files.
        :paramtype hour_metrics: ~azure.storage.fileshare.models.Metrics
        :keyword minute_metrics: A summary of request statistics grouped by API in minute aggregates
         for files.
        :paramtype minute_metrics: ~azure.storage.fileshare.models.Metrics
        :keyword cors: The set of CORS rules.
        :paramtype cors: list[~azure.storage.fileshare.models.CorsRule]
        :keyword protocol: Protocol settings.
        :paramtype protocol: ~azure.storage.fileshare.models.ShareProtocolSettings
        """
        super(StorageServiceProperties, self).__init__(**kwargs)
        self.hour_metrics = kwargs.get('hour_metrics', None)
        self.minute_metrics = kwargs.get('minute_metrics', None)
        self.cors = kwargs.get('cors', None)
        self.protocol = kwargs.get('protocol', None)
