/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2017-2020 Yegor Bugayenko
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.cactoos.proc;

import java.util.List;
import org.cactoos.list.ListOf;
import org.cactoos.list.Synced;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.jupiter.api.Test;
import org.llorllale.cactoos.matchers.Assertion;
import org.llorllale.cactoos.matchers.MatcherOf;

/**
 * Test case for {@link ForEachInThreads}.
 *
 * @since 1.0
 * @checkstyle JavadocMethodCheck (500 lines)
 * @checkstyle ClassDataAbstractionCouplingCheck (500 lines)
 */
public class ForEachInThreadsTest {

    @Test
    @SuppressWarnings("unchecked")
    void testProcIterable() throws Exception {
        final List<Integer> list = new Synced<>(
            new ListOf<>()
        );
        new ForEachInThreads<Integer>(
            new ProcNoNulls<>(
                list::add
            )
        ).exec(
            new ListOf<>(
                1, 2
            )
        );
        new Assertion<>(
            "List does not contain mapped Iterable elements",
            list,
            new IsIterableContainingInAnyOrder<>(
                new ListOf<>(
                    new MatcherOf<>(
                        value -> {
                            return value.equals(
                                1
                            );
                        }
                    ), new MatcherOf<>(
                        value -> {
                            return value.equals(
                                2
                            );
                        }
                    )
                )
            )
        ).affirm();
    }

}
