/*
  Fourier Synthesis Adders
  ========================

  The functions contain herein perform fourier synthesis on multiple 
  input buffers.

  The functions are named using the following format:
  fs_addxchannels() where x is the number of input channels. The function
  will be mathematically optimized for x number of channels.

  This software is brought to you by the letter A and the number 2

  Version: 1
  Author:  Robert Michael S Dean
  Copyright (c) 1999

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#include <limits.h>
#include <stdio.h>

#include <dbchannel.h>
#include <dbdebug.h>

int int_buffer[2048];
int clip_count;

extern dbfsd_data* sysdata;

/*
  fs_addNchannels - nieve fourier synthesis solution.  I say nieve as in 
                    it uses straight loops while the functions are optimized
					a specific number of channels.
 */
signed short * fs_addNchannels(signed short* output, channel_buf ** 
							   in_channels, int num_channels)
{

	printf("AddNChannels NOT IMPELEMENTED YET!!!\n");

/* 	int m,n,o, *temp_int_buffer; */
/* 	signed short * tempbuf, * out; */
/* 	channel_buf *tempch; */

/* 	temp_int_buffer = int_buffer; */
/* 	tempch = in_channels; */

	/*find first buffer with data_ready to init the int_buffer*/

/* 	m = 0; */
/* 	while(in_channels[m].data1_ready == FALSE) */
/* 	{ */
/* 		m++; */
/* 		tempch++; */
/* 	} */
   
/* 	tempbuf = tempch->buf; */
/* 	tempch->data1_ready = FALSE; */

	/*init temp int buffer*/
/* 	for(n=0; n < DB_BUFSIZE_SHORT; n++) */
/* 	{ */
/* 		*temp_int_buffer++ = *tempbuf++; */
/* 	} */

/* 	m++;   */
/* 	temp_int_buffer = int_buffer; */

/* 	for(o = m; o < num_channels; o++) */
/* 	{ */
/* 		if(tempch->data1_ready) */
/* 	    { */
			/* 			tempch->data1_ready = FALSE; */
/* 			tempbuf = tempch->buf; */
/* 			for(n = 0; n < DB_BUFSIZE_SHORT; n++) */
/* 			{ */
/* 				*temp_int_buffer++ += *tempbuf++; */
/* 			} */
/* 	    } */
/* 		tempch++; */
/* 	} */

/* 	out = output; */
/* 	temp_int_buffer = int_buffer; */
   
/* 	for(n = 0; n < DB_BUFSIZE_SHORT; n++) */
/* 	{ */
/* 		*out++ = *temp_int_buffer++ / num_channels; */
/* 	} */

	return output;
}


/*
  fs_add2channels - adds two buffers into the output buffer.
  
     addition is done using the int tempval to avoid overflow
     issues from adding two 16 bit values within a 16bit value.
 */
signed short * fs_add2channels(signed short * output, channel_buf * input1, 
							   channel_buf * input2)
{
	signed short* out, * in1, * in2;
	int i,tempval;

	out = output;
	in1 = input1->buf;
	in2 = input2->buf;

	clip_count = 0;

	for(i = 0; i < (DB_BUFSIZE_SHORT / 2); i++)
	{
		/*left channel*/
	 
		tempval = *in1++ + *in2++;

		/* applying clipping algorithm... */
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}

		*out = (signed short) tempval;
		out++;
	 
		/*right channel*/
		tempval = *in1++ + *in2++;
		/* applying clipping algorithm... */
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32688) {tempval = -32767; clip_count++;}
		*out = (signed short) tempval;
		out++;
	}

	/* set clipping detector */
	if(clip_count > 0)
	{
		if(clip_count > sysdata->clipping) sysdata->clipping = clip_count;
/* 		Debug("FSADDERS: Clipped %d out of %d samples",clip_count,DB_BUFSIZE_SHORT / 2); */
	}
	else
	{
		/* sysdata->clipping = 0; */
	}
  
	return output;
}


signed short * fs_add3channels(signed short * output, channel_buf * input1, 
							   channel_buf * input2, channel_buf* input3)
{
	signed short *out, *in1, *in2, *in3;
	int i,tempval;
   
	out = output;
	in1 = input1->buf;
	in2 = input2->buf;
	in3 = input3->buf;

	clip_count = 0;
   
	for(i = 0; i < (DB_BUFSIZE_SHORT / 2); i++)
	{
		tempval = *in1++ + *in2++ + *in3++;
		/* applying clipping algorithm... */
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}

		*out = (signed short) tempval;
		out++;
	 
		/*right channel*/
		tempval = *in1++ + *in2++ + *in3++;
		/* applying clipping algorithm... */
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32688) {tempval = -32767; clip_count++;}
		*out = (signed short) tempval;
		out++;
	}

	if(clip_count > 0)
	{
		if(clip_count > sysdata->clipping) sysdata->clipping = clip_count;
/* 		Debug("FSADDERS: Clipped %d out of %d samples",clip_count,DB_BUFSIZE_SHORT / 2); */
	}
	else
	{
		/* sysdata->clipping = 0; */
	}

	return output;
}


signed short * fs_add4channels(signed short *output, channel_buf *input1, 
							   channel_buf *input2, channel_buf *input3, 
							   channel_buf *input4)
{
	signed short* out, * in1, * in2, *in3, *in4;
	int i,tempval;

	out = output;
	in1 = input1->buf;
	in2 = input2->buf;
	in3 = input3->buf;
	in4 = input4->buf;

	clip_count = 0;
   
	for(i = 0; i < (DB_BUFSIZE_SHORT / 2); i++)
	{
		tempval = *in1++ + *in2++ + *in3++ + *in4++;
		//tempval = tempval / 4;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	 
		*out = (signed short) tempval;
		out++;

		tempval = *in1++ + *in2++ + *in3++ + *in4++;
		//tempval = tempval / 4;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	 
		*out = (signed short) tempval;
		out++;
	}

	if(clip_count > 0)
	{
		if(clip_count > sysdata->clipping) sysdata->clipping = clip_count;
/* 		Debug("FSADDERS: Clipped %d out of %d samples",clip_count,DB_BUFSIZE_SHORT / 2); */
	}
	else
	{
		/* sysdata->clipping = 0; */
	}

	return output;
}



signed short * fs_add5channels(signed short *output, channel_buf *input1, 
							   channel_buf *input2, channel_buf *input3, 
							   channel_buf *input4, channel_buf *input5)
{
	signed short* out, * in1, * in2, *in3, *in4, *in5;
	int i,tempval;

	clip_count = 0;

	out = output;
	in1 = input1->buf;
	in2 = input2->buf;
	in3 = input3->buf;
	in4 = input4->buf;
	in5 = input5->buf;

	for(i = 0; i < (DB_BUFSIZE_SHORT / 2); i++)
	{
		tempval = *in1++ + *in2++ + *in3++ + *in4++ + *in5++;
		//tempval = tempval / 5;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	
		*out = (signed short) tempval;
		out++;

		tempval = *in1++ + *in2++ + *in3++ + *in4++ + *in5++;
		//tempval = tempval / 5;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	
		*out = (signed short) tempval;
		out++;
	}

	if(clip_count > 0)
	{
		if(clip_count > sysdata->clipping) sysdata->clipping = clip_count;
/* 		Debug("FSADDERS: Clipped %d out of %d samples",clip_count,DB_BUFSIZE_SHORT / 2); */
	}
	else
	{
		/* sysdata->clipping = 0; */
	}

	return output;
}


signed short * fs_add6channels(signed short *output, channel_buf *input1, 
							   channel_buf *input2, channel_buf *input3, 
							   channel_buf *input4, channel_buf *input5,
							   channel_buf *input6)
{
	signed short* out, * in1, * in2, *in3, *in4, *in5, *in6;
	int i,tempval;

	clip_count = 0;

	out = output;
	in1 = input1->buf;
	in2 = input2->buf;
	in3 = input3->buf;
	in4 = input4->buf;
	in5 = input5->buf;
	in6 = input6->buf;

	for(i = 0; i < (DB_BUFSIZE_SHORT / 2); i++)
	{
		tempval = *in1++ + *in2++ + *in3++ + *in4++ + *in5++ + *in6++;
		//tempval = tempval / 6;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	 
		*out = (signed short) tempval;
		out++;

		tempval = *in1++ + *in2++ + *in3++ + *in4++ + *in5++ + *in6++;
		//tempval = tempval / 6;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	 
		*out = (signed short) tempval;
		out++;
	}

	if(clip_count > 0)
	{
		if(clip_count > sysdata->clipping) sysdata->clipping = clip_count;
		Debug("FSADDERS: Clipped %d out of %d samples",clip_count,DB_BUFSIZE_SHORT / 2);
	}
	else
	{
		/* sysdata->clipping = 0; */
	}

	return output;
}


signed short * fs_add7channels(signed short *output, channel_buf *input1, 
							   channel_buf *input2, channel_buf *input3, 
							   channel_buf *input4, channel_buf *input5,
							   channel_buf *input6, channel_buf *input7)
{
	signed short* out, * in1, * in2, *in3, *in4, *in5, *in6, *in7;
	int i,tempval;

	clip_count = 0;

	out = output;
	in1 = input1->buf;
	in2 = input2->buf;
	in3 = input3->buf;
	in4 = input4->buf;
	in5 = input5->buf;
	in6 = input6->buf;
	in7 = input7->buf;

	for(i = 0; i < (DB_BUFSIZE_SHORT / 2); i++)
	{
		tempval = *in1++ + *in2++ + *in3++ + *in4++ 
			+ *in5++ + *in6++ + *in7++;
		//tempval = tempval / 7;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	 
		*out = (signed short) tempval;
		out++;

		tempval = *in1++ + *in2++ + *in3++ + *in4++ 
			+ *in5++ + *in6++ + *in7++;
		//tempval = tempval / 7;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	 
		*out = (signed short) tempval;
		out++;
	}

	if(clip_count > 0)
	{
		if(clip_count > sysdata->clipping) sysdata->clipping = clip_count;
		Debug("FSADDERS: Clipped %d out of %d samples",clip_count,DB_BUFSIZE_SHORT / 2);
	}
	else
	{
		/* sysdata->clipping = 0; */
	}

	return output;
}


signed short * fs_add8channels(signed short *output, channel_buf *input1, 
							   channel_buf *input2, channel_buf *input3, 
							   channel_buf *input4, channel_buf *input5,
							   channel_buf *input6, channel_buf *input7,
							   channel_buf *input8)
{
	signed short* out, * in1, * in2, *in3, *in4, *in5, *in6, *in7, *in8;
	int i,tempval;

	clip_count = 0;

	out = output;
	in1 = input1->buf;
	in2 = input2->buf;
	in3 = input3->buf;
	in4 = input4->buf;
	in5 = input5->buf;
	in6 = input6->buf;
	in7 = input7->buf;
	in8 = input8->buf;

	for(i = 0; i < (DB_BUFSIZE_SHORT / 2); i++)
	{
		tempval = *in1++ + *in2++ + *in3++ + *in4++ 
			+ *in5++ + *in6++ + *in7++ + *in8++;
		//tempval = tempval / 8;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	 
		*out = (signed short) tempval;
		out++;

		tempval = *in1++ + *in2++ + *in3++ + *in4++ 
			+ *in5++ + *in6++ + *in7++ + *in8++;
		//tempval = tempval / 8;
	 
		if(tempval > 32767) {tempval = 32767; clip_count++;}
		if(tempval < -32767) {tempval = -32767; clip_count++;}
	 
		*out = (signed short) tempval;
		out++;
	}

	if(clip_count > 0)
	{
		if(clip_count > sysdata->clipping) sysdata->clipping = clip_count;
		Debug("FSADDERS: Clipped %d out of %d samples",clip_count,DB_BUFSIZE_SHORT / 2);
	}
	else
	{
		/* sysdata->clipping = 0; */
	}

	return output;
}
