/* -*- Mode: C++; tab-width: 4 -*- */
/* vi: set ts=4 sw=4 noexpandtab: */

/*
 * Copyright (C) 2009, 2010 Florian Weimer <fw@deneb.enyo.de>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef DIAGNOSTICS__EXTENSIONS__STACKTRACE__DESCRIPTOR__INCLUDE_GUARD
#define DIAGNOSTICS__EXTENSIONS__STACKTRACE__DESCRIPTOR__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/extensions/stacktrace/namespace.hpp>

#include <cstddef>

DIAGNOSTICS_NAMESPACE_BEGIN;
STACKTRACE_NAMESAPCE_BEGIN;
namespace POSIX {

class Descriptor {
  int desc;

  Descriptor(const Descriptor&);
  void operator=(const Descriptor&);

public:
  Descriptor()
    : desc(-1)
  {
  }

  Descriptor(int d)
    : desc(d)
  {
  }

  ~Descriptor() throw ()
  {
    CloseNoThrow();
  }

  bool IsOpen() const
  {
    return desc >= 0;
  }

  int GetRaw() const
  {
    return desc;
  }

  int Release()
  {
    int d = desc;
    desc = -1;
    return d;
  }

  void OpenReadOnly(const char *);
  //void OpenReadOnly(const Descriptor &dir, const char *); // uses openat

  void swap(Descriptor& o)
  {
    int d = o.desc;
    o.desc = desc;
    desc = d;
  }

  void Reset(int d)
  {
    Close();
    desc = d;
  }

  void Close();
  void CloseNoThrow() throw ();

  size_t read(void *, size_t);

  void SetCloseOnExec(bool);
  void SetNonBlocking(bool);
};

class Pipe
{
  Descriptor read, write;

public:
  Pipe();
  ~Pipe();

  Descriptor& Read()
  {
    return read;
  }

  Descriptor& Write()
  {
    return write;
  }
};

} // Enyo::POSIX
STACKTRACE_NAMESAPCE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

