/* -*- Mode: C++; tab-width: 4 -*- */
/* vi: set ts=4 sw=4 noexpandtab: */

/*
 * Copyright (C) 2009 Florian Weimer <fw@deneb.enyo.de>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef DIAGNOSTICS__EXTENSIONS__STACKTRACE__POSIX__INCLUDE_GUARD
#define DIAGNOSTICS__EXTENSIONS__STACKTRACE__POSIX__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/extensions/stacktrace/namespace.hpp>

#include <string>
#include <stdexcept>

DIAGNOSTICS_NAMESPACE_BEGIN;
STACKTRACE_NAMESAPCE_BEGIN;
  namespace POSIX {
    // Returns true if PATH is absolute. Existence and permissions are
    // not checked.
    bool IsAbsolute(const std::string& path);

    // Returns the path of the current directory.
    std::string Cwd();

    // Returns true if PATH exists (that is, access(F_OK) returns
    // true).
    bool Exists(const std::string& path);

    // Returns true if PATH is executable (that is, access(X_OK)
    // returns true).
    bool IsExecutable(const std::string& path);

    // Searches for CMD in in PATH (which has to be colon-separated)
    // if it is not an absolute path name, and returns the first
    // matching executable entry.  Throws error(ENOENT) if the command
    // cannot be found, and error(EACCES) if all the commands found
    // lack appropriate permission.
    std::string SearchCommand(const std::string& cmd,
                              const std::string& path);

    // Creates PATH safely, so that it is guaranteed to be owned by
    // the caller's UID, even if it is located in a 1777 directory.
    // An existing file is deleted.
    void CreateSafely(const std::string& path);

    // Renames FROM to PATH, replacing the latter if it exists.
    void Rename(const std::string& from, const std::string& to);

    // Resolves symbolic links.
    std::string RealPath(const std::string &);

  } // Enyo::POSIX
STACKTRACE_NAMESAPCE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

