-- $Id$ 

-- test for some different arrays

-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

library std;
use std.standard.all;

package types is
	type word is array(0 to 31) of bit;
	type bitarray is array(INTEGER range <>) of bit;
	type memory is array(INTEGER range <>) of word;
	type memory2 is array(0 to 127, 0 to 31) of bit;
	subtype small is integer range 0 to 127;
	type memory3 is array(small, 0 to 31) of bit;
	--type memory3 is array(small1, 0 to 31) of bit;
	-- illegal:
	--type memfault is array(INTEGER range <>) of word(0 to 31);
end package types;

library std;
use std.standard.all;
use types.all;
entity nullentity is
end entity nullentity;

architecture implementation of nullentity is
begin	
	x : process 
		constant memsize : integer := 127;
		variable foo : word; -- no index constrained allowed here!
		variable bar : memory(0 to memsize);
		variable tofu : memory2;
		-- FIXME see aggregates.vhdl
		--constant foobar : bitarray := "11110000"; -- (0 to 7)
	begin
		bar(0)(0) := '1';
		bar(0)(1) := '0';
		tofu(0, 0) := '1';
		tofu(0, 1) := '0';
		bar(0 to 10) := bar(10 to 20);
		bar(0) := "11110000111100001111000011110000";
	end process;
end implementation;
