# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
ifeq ($(GARDEN_ARCH),x86_64)
.PHONY: all
all:: archlinux-cloud.$(GARDEN_ARCH).qcow2 archlinux-cloud.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/archlinux/Arch-Linux-$(GARDEN_ARCH)-cloudimg.qcow2
endif

GARDEN_SYSTEMS += archlinux-cloud.x86_64

archlinux-cloud.x86_64.qcow2: $(GARDEN_DL_DIR)/archlinux/archlinux-cloud.x86_64.qcow2 archlinux-cloud.seed.iso archlinux-cloud.x86_64.efi-code.img archlinux-cloud.x86_64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(GARDEN_DL_DIR)/archlinux/Arch-Linux-x86_64-cloudimg.qcow2: | $(GARDEN_DL_DIR)/archlinux
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://geo.mirror.pkgbuild.com/images/latest/Arch-Linux-x86_64-cloudimg.qcow2)

$(GARDEN_DL_DIR)/archlinux/archlinux-cloud.x86_64.qcow2: | $(GARDEN_DL_DIR)/archlinux $(GARDEN_DL_DIR)/archlinux/Arch-Linux-x86_64-cloudimg.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

archlinux-cloud.x86_64.run: $(MAKEFILE_LIST) | archlinux-cloud.x86_64.qcow2 archlinux-cloud.x86_64.efi-code.img archlinux-cloud.x86_64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/archlinux" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(GARDEN_DL_DIR)/archlinux: | $(GARDEN_DL_DIR)
	mkdir -p $@

archlinux-cloud.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,archlinux)
archlinux-cloud.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

archlinux-cloud.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,ARCHLINUX,),archlinux,archlinux)
archlinux-cloud.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

.PHONY: clean
clean::
	rm -f archlinux-cloud.x86_64.qcow2 archlinux-cloud.x86_64.run
	rm -f $(GARDEN_DL_DIR)/archlinux/archlinux-cloud.x86_64.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/archlinux/Arch-Linux-x86_64-cloudimg.qcow2
