#include <stdint.h>
#include "tones.h"

static int16_t pattern_ringback[1000] = {
	0x00e5, 0x0070, 0x001c, 0x0001, 0x001c, 0x0070, 0x00e5, 0x0168,
	0x01d8, 0x021a, 0x0219, 0x01b9, 0x010a, 0xfffd, 0xfec2, 0xfd64,
	0xfc20, 0xfb18, 0xfa78, 0xfa66, 0xfaed, 0xfc1c, 0xfdd7, 0xffff,
	0x0264, 0x04c0, 0x06db, 0x0862, 0x0933, 0x0914, 0x0806, 0x060c,
	0x0349, 0x0001, 0xfc7c, 0xf91b, 0xf638, 0xf427, 0xf330, 0xf379,
	0xf50c, 0xf7d7, 0xfb98, 0xffff, 0x04a3, 0x08fd, 0x0cb3, 0x0f3d,
	0x1065, 0x0feb, 0x0dd6, 0x0a40, 0x0582, 0xffff, 0xfa48, 0xf4ec,
	0xf077, 0xed68, 0xec1b, 0xecbe, 0xef58, 0xf3b2, 0xf96c, 0x0001,
	0x06c8, 0x0d1f, 0x1251, 0x15df, 0x1752, 0x1684, 0x136b, 0x0e4f,
	0x079f, 0x0001, 0xf82a, 0xf0eb, 0xeaf2, 0xe6f7, 0xe551, 0xe657,
	0xe9e3, 0xefc0, 0xf75c, 0xfffe, 0x08da, 0x1102, 0x17ad, 0x1c23,
	0x1de6, 0x1cbe, 0x18b3, 0x1223, 0x09a0, 0x0001, 0xf62d, 0xed22,
	0xe5ca, 0xe0e2, 0xdefe, 0xe04d, 0xe4ce, 0xec0d, 0xf56d, 0x0001,
	0x0ac0, 0x14a9, 0x1ca2, 0x21fc, 0x23fc, 0x2287, 0x1d96, 0x15af,
	0x0b79, 0x0003, 0xf454, 0xe9ac, 0xe103, 0xdb55, 0xd924, 0xdace,
	0xe01f, 0xe8b0, 0xf3a8, 0xffff, 0x0c83, 0x17f3, 0x212e, 0x2741,
	0x2988, 0x27c2, 0x2203, 0x18e2, 0x0d24, 0x0003, 0xf2ae, 0xe68b,
	0xdcbf, 0xd655, 0xd3ef, 0xd5de, 0xdbf5, 0xe5ae, 0xf215, 0x0000,
	0x0e11, 0x1ade, 0x2531, 0x2bea, 0x2e6c, 0x2c5b, 0x25ea, 0x1bac,
	0x0e9f, 0xffff, 0xf141, 0xe3ce, 0xd90c, 0xd1fb, 0xcf6d, 0xd198,
	0xd85d, 0xe316, 0xf0bb, 0x0001, 0x0f63, 0x1d61, 0x289a, 0x2fe7,
	0x3290, 0x3043, 0x2936, 0x1e09, 0x0fdc, 0xffff, 0xf00a, 0xe18a,
	0xd5ef, 0xce60, 0xcbad, 0xce0d, 0xd567, 0xe0f1, 0xef9e, 0x0003,
	0x1076, 0x1f6f, 0x2b5e, 0x3322, 0x35e8, 0x336a, 0x2bd8, 0x1ff0,
	0x10d8, 0xfffc, 0xef1a, 0xdfb9, 0xd381, 0xcb8e, 0xc8ba, 0xcb54,
	0xd315, 0xdf4e, 0xeec4, 0x0003, 0x1149, 0x20fb, 0x2d74, 0x358e,
	0x3868, 0x35bf, 0x2dcc, 0x2155, 0x118d, 0x0001, 0xee63, 0xde74,
	0xd1c3, 0xc98c, 0xc6b0, 0xc965, 0xd180, 0xde2b, 0xee31, 0xffff,
	0x11dc, 0x21fc, 0x2ed9, 0x371e, 0x3a05, 0x373b, 0x2f06, 0x2234,
	0x11fd, 0x0002, 0xedf8, 0xddb3, 0xd0bf, 0xc86b, 0xc585, 0xc85a,
	0xd0a2, 0xdd94, 0xede2, 0x0003, 0x121d, 0x227c, 0x2f7b, 0x37d2,
	0x3ab8, 0x37d7, 0x2f85, 0x2285, 0x1228, 0xfffe, 0xeddb, 0xdd78,
	0xd07f, 0xc825, 0xc54b, 0xc82b, 0xd088, 0xdd82, 0xede4, 0xfffd,
	0x121e, 0x226c, 0x2f5e, 0x37a6, 0x3a7a, 0x3798, 0x2f3d, 0x2252,
	0x1202, 0x0002, 0xee02, 0xddcc, 0xd0fb, 0xc8c3, 0xc5fc, 0xc8e1,
	0xd12a, 0xddff, 0xee2a, 0xfffc, 0x11d2, 0x21d3, 0x2e81, 0x369a,
	0x3952, 0x3672, 0x2e3f, 0x218a, 0x119f, 0xfffd, 0xee75, 0xdea9,
	0xd236, 0xca3f, 0xc799, 0xca73, 0xd289, 0xdf09, 0xeeb2, 0x0001,
	0x1139, 0x20b5, 0x2ce8, 0x34af, 0x3744, 0x3472, 0x2c81, 0x2043,
	0x10ea, 0x0002, 0xef28, 0xe012, 0xd424, 0xcc9a, 0xca16, 0xccdf,
	0xd4a0, 0xe094, 0xef87, 0x0000, 0x1061, 0x1f0c, 0x2a9e, 0x31ee,
	0x3457, 0x319d, 0x2a12, 0x1e77, 0x0ff5, 0x0001, 0xf024, 0xe1f7,
	0xd6ca, 0xcfbd, 0xcd71, 0xd016, 0xd76b, 0xe29a, 0xf09f, 0x0001,
	0x0f41, 0x1cee, 0x27a0, 0x2e69, 0x3094, 0x2e03, 0x26f6, 0x1c31,
	0x0ebf, 0x0001, 0xf160, 0xe455, 0xda16, 0xd3a5, 0xd195, 0xd413,
	0xdad1, 0xe521, 0xf1ef, 0x0002, 0x0de8, 0x1a55, 0x2408, 0x2a25,
	0x2c0d, 0x29b0, 0x233c, 0x197a, 0x0d4e, 0xffff, 0xf2db, 0xe71f,
	0xddfd, 0xd83c, 0xd67a, 0xd8bd, 0xded4, 0xe80d, 0xf37b, 0x0003,
	0x0c55, 0x1754, 0x1fdd, 0x2536, 0x26d9, 0x24ad, 0x1efb, 0x1657,
	0x0ba8, 0x0001, 0xf484, 0xea54, 0xe267, 0xdd7d, 0xdbfd, 0xde0d,
	0xe355, 0xeb5f, 0xf53a, 0x0002, 0x0a93, 0x13f0, 0x1b36, 0x1fb0,
	0x2104, 0x1f1d, 0x1a36, 0x12de, 0x09d3, 0xffff, 0xf660, 0xeddd,
	0xe74d, 0xe342, 0xe219, 0xe3de, 0xe853, 0xeefc, 0xf72a, 0xfffd,
	0x08a8, 0x103e, 0x161d, 0x19ab, 0x1aac, 0x190c, 0x150b, 0x0f18,
	0x07d4, 0x0001, 0xf85e, 0xf1b4, 0xec93, 0xe97e, 0xe8ac, 0xea22,
	0xedae, 0xf2e4, 0xf934, 0x0002, 0x0692, 0x0c50, 0x10a7, 0x1342,
	0x13e5, 0x1298, 0x0f8a, 0x0b13, 0x05b9, 0x0000, 0xfa7e, 0xf5c1,
	0xf229, 0xf016, 0xef9c, 0xf0c0, 0xf351, 0xf6fe, 0xfb61, 0x0000,
	0x0467, 0x082a, 0x0af3, 0x0c87, 0x0cd2, 0x0bd6, 0x09ca, 0x06e4,
	0x0384, 0xffff, 0xfcb8, 0xf9f3, 0xf7fc, 0xf6e8, 0xf6d1, 0xf79a,
	0xf92a, 0xfb3c, 0xfd9f, 0xfffe, 0x022b, 0x03e4, 0x0512, 0x059c,
	0x0585, 0x04ea, 0x03e0, 0x029b, 0x0140, 0xffff, 0xfefb, 0xfe42,
	0xfdec, 0xfde2, 0xfe29, 0xfe98, 0xff1c, 0xff90, 0xffe3, 0xffff,
	0xffe5, 0xff8f, 0xff1c, 0xfe98, 0xfe26, 0xfde9, 0xfde4, 0xfe49,
	0xfef5, 0x0004, 0x013d, 0x029d, 0x03de, 0x04ea, 0x0587, 0x059b,
	0x0512, 0x03e4, 0x022b, 0xfffd, 0xfda1, 0xfb3b, 0xf929, 0xf79c,
	0xf6ce, 0xf6ec, 0xf7f9, 0xf9f5, 0xfcb6, 0x0000, 0x0383, 0x06e6,
	0x09c8, 0x0bd9, 0x0cce, 0x0c8a, 0x0af1, 0x082c, 0x0467, 0xfffe,
	0xfb64, 0xf6fa, 0xf355, 0xf0bd, 0xef9e, 0xf015, 0xf229, 0xf5c1,
	0xfa7d, 0x0003, 0x05b5, 0x0b17, 0x0f87, 0x1299, 0x13e5, 0x1342,
	0x10a7, 0x0c51, 0x0690, 0x0002, 0xf936, 0xf2e2, 0xedb0, 0xea20,
	0xe8ad, 0xe97e, 0xec94, 0xf1b1, 0xf861, 0xffff, 0x07d6, 0x0f17,
	0x150a, 0x190d, 0x1aab, 0x19ac, 0x161d, 0x103e, 0x08a7, 0xfffe,
	0xf729, 0xeefc, 0xe855, 0xe3db, 0xe21b, 0xe342, 0xe74c, 0xeddf,
	0xf65d, 0x0002, 0x09d1, 0x12e0, 0x1a34, 0x1f1e, 0x2104, 0x1fb1,
	0x1b35, 0x13f0, 0x0a94, 0x0000, 0xf53d, 0xeb5c, 0xe357, 0xde0d,
	0xdbfc, 0xdd7e, 0xe266, 0xea54, 0xf486, 0xfffe, 0x0baa, 0x1657,
	0x1ef9, 0x24b1, 0x26d5, 0x2538, 0x1fdd, 0x1754, 0x0c55, 0x0002,
	0xf37d, 0xe80c, 0xded4, 0xd8bf, 0xd675, 0xd842, 0xddf9, 0xe721,
	0xf2da, 0xffff, 0x0d4f, 0x1979, 0x233d, 0x29ae, 0x2c0e, 0x2a24,
	0x240a, 0x1a53, 0x0dea, 0xffff, 0xf1f1, 0xe51f, 0xdad3, 0xd412,
	0xd197, 0xd3a3, 0xda18, 0xe452, 0xf163, 0xffff, 0x0ec1, 0x1c30,
	0x26f7, 0x2e02, 0x3094, 0x2e68, 0x27a3, 0x1ceb, 0x0f43, 0x0002,
	0xf09a, 0xe2a1, 0xd765, 0xd019, 0xcd71, 0xcfbc, 0xd6cb, 0xe1f5,
	0xf026, 0x0001, 0x0ff4, 0x1e78, 0x2a10, 0x319f, 0x3456, 0x31ef,
	0x2a9d, 0x1f0e, 0x105f, 0x0000, 0xef88, 0xe093, 0xd4a2, 0xccdd,
	0xca18, 0xcc97, 0xd428, 0xe00e, 0xef2b, 0x0000, 0x10eb, 0x2043,
	0x2c81, 0x3473, 0x3741, 0x34b3, 0x2ce5, 0x20b7, 0x1138, 0x0000,
	0xeeb4, 0xdf09, 0xd288, 0xca74, 0xc796, 0xca43, 0xd233, 0xdeac,
	0xee71, 0x0002, 0x1199, 0x218f, 0x2e3c, 0x3673, 0x3953, 0x3697,
	0x2e83, 0x21d3, 0x11d1, 0xfffe, 0xee27, 0xde01, 0xd12a, 0xc8e0,
	0xc5fd, 0xc8c2, 0xd0fd, 0xddc9, 0xee06, 0xfffc, 0x1209, 0x224d,
	0x2f40, 0x3796, 0x3a7a, 0x37a7, 0x2f5d, 0x226e, 0x121c, 0xffff,
	0xede1, 0xdd85, 0xd086, 0xc82c, 0xc54b, 0xc825, 0xd07e, 0xdd79,
	0xedda, 0xffff, 0x1229, 0x2282, 0x2f87, 0x37d7, 0x3ab8, 0x37d2,
	0x2f7a, 0x227c, 0x121f, 0x0001, 0xede3, 0xdd93, 0xd0a3, 0xc859,
	0xc586, 0xc86a, 0xd0bf, 0xddb3, 0xedf9, 0x0001, 0x11fd, 0x2234,
	0x2f06, 0x373c, 0x3a04, 0x371f, 0x2ed7, 0x21ff, 0x11d9, 0x0002,
	0xee2e, 0xde2e, 0xd17c, 0xc96a, 0xc6ac, 0xc98e, 0xd1c2, 0xde74,
	0xee64, 0x0000, 0x118d, 0x2155, 0x2dcd, 0x35be, 0x3869, 0x358b,
	0x2d79, 0x20f6, 0x114e, 0xfffe, 0xeec8, 0xdf4b, 0xd318, 0xcb50,
	0xc8bd, 0xcb8e, 0xd37f, 0xdfbc, 0xef16, 0x0000, 0x10d5, 0x1ff2,
	0x2bd6, 0x336c, 0x35e7, 0x3322, 0x2b5f, 0x1f6d, 0x1078, 0x0001,
	0xef9f, 0xe0f3, 0xd563, 0xce12, 0xcba8, 0xce63, 0xd5ef, 0xe189,
	0xf00a, 0x0000, 0x0fda, 0x1e0c, 0x2934, 0x3044, 0x328f, 0x2fe8,
	0x2899, 0x1d62, 0x0f63, 0x0000, 0xf0bd, 0xe313, 0xd860, 0xd195,
	0xcf70, 0xd1f9, 0xd90e, 0xe3cb, 0xf144, 0xfffc, 0x0ea2, 0x1bab,
	0x25ea, 0x2c5c, 0x2e68, 0x2bf0, 0x252b, 0x1ae4, 0x0e0d, 0x0001,
	0xf216, 0xe5ac, 0xdbf7, 0xd5dd, 0xd3ef, 0xd656, 0xdcbe, 0xe68b,
	0xf2b0, 0xffff, 0x0d29, 0x18dd, 0x2208, 0x27be, 0x298b, 0x2740,
	0x212e, 0x17f3, 0x0c82, 0x0000, 0xf3aa, 0xe8ac, 0xe024, 0xdac8,
	0xd92a, 0xdb4f, 0xe108, 0xe9a8, 0xf458, 0x0000, 0x0b7b, 0x15ac,
	0x1d99, 0x2284, 0x2401, 0x21f6, 0x1ca8, 0x14a4, 0x0ac3, 0x0000,
	0xf56b, 0xec12, 0xe4c9, 0xe051, 0xdefb, 0xe0e3, 0xe5cb, 0xed20,
	0xf630, 0xfffe, 0x09a3, 0x1221, 0x18b4, 0x1cbe, 0x1de6, 0x1c23,
	0x17ad, 0x1103, 0x08d8, 0x0001, 0xf75a, 0xefc0, 0xe9e4, 0xe655,
	0xe553, 0xe6f7, 0xeaf1, 0xf0ec, 0xf829, 0x0001, 0x07a0, 0x0e4d,
	0x136f, 0x167e, 0x1759, 0x15d8, 0x1257, 0x0d1a, 0x06cc, 0xfffe,
	0xf96e, 0xf3b0, 0xef5a, 0xecbd, 0xec1b, 0xed68, 0xf077, 0xf4ec,
	0xfa47, 0x0002, 0x057d, 0x0a45, 0x0dd2, 0x0fed, 0x1064, 0x0f3e,
	0x0cb1, 0x0900, 0x04a1, 0xffff, 0xfb99, 0xf7d5, 0xf50f, 0xf377,
	0xf331, 0xf426, 0xf639, 0xf91a, 0xfc7e, 0xffff, 0x034a, 0x060b,
	0x0806, 0x0917, 0x092f, 0x0866, 0x06d5, 0x04c6, 0x0260, 0x0002,
	0xfdd6, 0xfc1a, 0xfaf0, 0xfa63, 0xfa7b, 0xfb15, 0xfc23, 0xfd62,
	0xfec3, 0xfffd, 0x0108, 0x01bc, 0x0217, 0x021a, 0x01db, 0x0164,
};

static int16_t pattern_400[20] = {
	0xffff, 0x11ce, 0x21db, 0x2e99, 0x36c9, 0x3997, 0x36ca, 0x2e99,
	0x21db, 0x11ce, 0xfffd, 0xee37, 0xde20, 0xd16c, 0xc933, 0xc66b,
	0xc935, 0xd168, 0xde24, 0xee34,
};

static int16_t tone_ringback[8000];
static int16_t tone_400[8000];

extern int16_t *ringback_spl;
extern int ringback_size;
extern int ringback_max;

extern int16_t *busy_spl;
extern int busy_size;
extern int busy_max;

extern int16_t *congestion_spl;
extern int congestion_size;
extern int congestion_max;

void init_tones(void)
{
	int i, j;

	for (i = 0, j = 0; i < 8000; i++) {
		tone_ringback[i] = pattern_ringback[j++];
		if (j == 1000)
			j = 0;
	}
	for (i = 0, j = 0; i < 8000; i++) {
		tone_400[i] = pattern_400[j++];
		if (j == 20)
			j = 0;
	}

	ringback_spl = tone_ringback;
	ringback_size = 8 * 1000;
	ringback_max = 8 * 3000;

	busy_spl = tone_400;
	busy_size = 8 * 500;
	busy_max = 8 * 1000;

	congestion_spl = tone_400;
	congestion_size = 8 * 500;
	congestion_max = 8 * 1000;
}

