/*
 * Copyright (c) 2004-2014 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation, Steven Munroe - initial API and implementation
 */

#ifndef __SASTYPE__H
#define __SASTYPE__H

#include <stddef.h>

typedef size_t block_size_t;
/* SAS Block typing system. A sequence of 4 8-bit fields with the following meanings:
 * high order: type-group, i.e. SAS_RUNTIME, USER_DEFINED.
 *                   type, i.e. SAS_ANCHOR, SAS_HEAP, ... 
 *                   sub-type, i.e. SAS_SIMPLE_HEAP, ...
 *                   version #.
 */
typedef unsigned int sas_type_t;

#define SAS_GROUP_MASK			0xff000000
#define SAS_TYPE_MASK			0x00ff0000
#define SAS_SUB_TYPE_MASK		0x0000ff00
#define SAS_VERSION_MASK		0x000000ff

#define SAS_TYPE_CHECK_MASK \
  (SAS_USERDEFINED_GROUP | SAS_TYPE_MASK)
#define SAS_SUBTYPE_CHECK_MASK \
  (SAS_GROUP_MASK | SAS_TYPE_MASK | SAS_SUB_TYPE_MASK)

#define SAS_PERSISTENT_GROUP		0x10000000
#define SAS_SHAREDTEMP_GROUP		0x20000000
#define SAS_USERDEFINED_GROUP		0x80000000

#define SAS_ANCHOR_TYPE			0x00010000
#define SAS_PRIMARY_SUBTYPE		0x00000100

#define SAS_LOCKTABLE_SUBTYPE		0x00000100

#define SAS_HEAP_TYPE			0x00100000
#define SAS_HEAP_TYPE_MASK		0x00F00000
#define SAS_SIMPLEHEAP_TYPE		0x00100000
#define SAS_SIMPLESTACK_TYPE		0x00200000
#define SAS_SIMPLESPACE_TYPE		0x00300000
#define SAS_LOCKFREEHEAP_TYPE		0x00400000
#define SAS_LOCKFREELOG_TYPE		0x00500000
#define SAS_LOGPORTAL_TYPE 		0x00600000
#define SAS_PCQUEUE_TYPE 		0x00700000
#define SAS_PCQUEUE_TM_SUBTYPE 		0x00000200
#define SAS_COMPOUNDHEAP_TYPE 		0x00110000
#define SAS_STRINGBTREENODE_SUBTYPE 	0x00000200
#define SAS_STRINGBTREE_SUBTYPE 	0x00000200
#define SAS_INDEXNODE_SUBTYPE 		0x00000300
#define SAS_INDEX_SUBTYPE 		0x00000300
#define SAS_CONTEXT_SUBTYPE 		0x00000400

/* SAS RUNTIME ANCHOR version 0 */
#define SAS_RUNTIME_ANCHOR \
  (SAS_PERSISTENT_GROUP | SAS_ANCHOR_TYPE | SAS_PRIMARY_SUBTYPE)

/* SAS RUNTIME SIMPLE HEAP version 0 */
#define SAS_RUNTIME_SIMPLEHEAP \
  (SAS_PERSISTENT_GROUP | SAS_SIMPLEHEAP_TYPE | SAS_PRIMARY_SUBTYPE)

/* SAS RUNTIME COMPOUND HEAP version 0 */
#define SAS_RUNTIME_COMPOUNDHEAP \
  (SAS_PERSISTENT_GROUP | SAS_COMPOUNDHEAP_TYPE | SAS_PRIMARY_SUBTYPE)

/* SAS RUNTIME SIMPLE STACK version 0 */
#define SAS_RUNTIME_SIMPLESTACK \
  (SAS_PERSISTENT_GROUP | SAS_SIMPLESTACK_TYPE | SAS_PRIMARY_SUBTYPE)

/* SAS RUNTIME SIMPLE STACK version 0 */
#define SAS_RUNTIME_SIMPLESPACE \
  (SAS_PERSISTENT_GROUP | SAS_SIMPLESPACE_TYPE | SAS_PRIMARY_SUBTYPE)

/* SAS RUNTIME LOCKFREEHEAP version 0 */
#define SAS_RUNTIME_LOCKFREEHEAP \
  (SAS_PERSISTENT_GROUP | SAS_LOCKFREEHEAP_TYPE | SAS_PRIMARY_SUBTYPE)

/* SAS RUNTIME  LOCKFREELOGGER version 0 */
#define SAS_RUNTIME_LOCKFREELOGGER \
  (SAS_PERSISTENT_GROUP | SAS_LOCKFREELOG_TYPE | SAS_PRIMARY_SUBTYPE)

/* SAS RUNTIME  LOGPORTAL version 0 */
#define SAS_RUNTIME_LOGPORTAL \
  (SAS_PERSISTENT_GROUP | SAS_LOGPORTAL_TYPE | SAS_PRIMARY_SUBTYPE)

/* SAS RUNTIME  PCQUEUE version 0 */
#define SAS_RUNTIME_PCQUEUE \
  (SAS_PERSISTENT_GROUP | SAS_PCQUEUE_TYPE | SAS_PRIMARY_SUBTYPE)

/* SAS RUNTIME  PCQUEUE_TM version 0 */
#define SAS_RUNTIME_PCQUEUE_TM \
  (SAS_PERSISTENT_GROUP | SAS_PCQUEUE_TYPE | SAS_PCQUEUE_TM_SUBTYPE)

/* SAS RUNTIME STRINGBTREENODE HEAP version 0 */
#define SAS_RUNTIME_STRINGBTREENODE \
  (SAS_PERSISTENT_GROUP | SAS_SIMPLEHEAP_TYPE | SAS_STRINGBTREENODE_SUBTYPE)

/* SAS RUNTIME STRINGBTREE HEAP version 0 */
#define SAS_RUNTIME_STRINGBTREE \
  (SAS_PERSISTENT_GROUP | SAS_COMPOUNDHEAP_TYPE | SAS_STRINGBTREE_SUBTYPE)

/* SAS RUNTIME INDEXNODE HEAP version 0 */
#define SAS_RUNTIME_INDEXNODE \
  (SAS_PERSISTENT_GROUP | SAS_SIMPLEHEAP_TYPE | SAS_INDEXNODE_SUBTYPE)

/* SAS RUNTIME INDEX HEAP version 0 */
#define SAS_RUNTIME_INDEX \
  (SAS_PERSISTENT_GROUP | SAS_COMPOUNDHEAP_TYPE | SAS_INDEX_SUBTYPE)

/* SAS RUNTIME CONTEXT version 0 */
#define SAS_RUNTIME_CONTEXT \
  (SAS_PERSISTENT_GROUP | SAS_SIMPLEHEAP_TYPE | SAS_CONTEXT_SUBTYPE)

/* SAS RUNTIME LOCKTABLE version 0 */
#define SAS_RUNTIME_LOCKTABLE \
  (SAS_SHAREDTEMP_GROUP | SAS_SIMPLEHEAP_TYPE | SAS_LOCKTABLE_SUBTYPE)

#endif
