---
title: Detector
---

This page documents tools that work with [detectors](../Simulation/Output/Induction_Loops_Detectors_(E1).md) and detector [flow files](../Demand/Routes_from_Observation_Points.md#computing_flows).

# flowrouter.py

"flowrouter.py" serves as a drop in replacement for
[dfrouter](../dfrouter.md) which calculates a set of routes **-o** and
traffic flows **-e** from given detectors **-d** and their measurements **-f** on a given
network (option **-n**).

Flowrouter works by solving a maximum flow problem in the given network
assuming the measured flows as capacity. The input data is by default
aggregated over the whole file but can be split into intervals by
setting **-i**. Example call for hourly aggregation:

```
<SUMO_HOME>/tools/detector/flowrouter.py -n input_net.net.xml -d detectors.xml -f flows20140520.csv -o routes.xml -e flows.xml -i 60
```

Detectors which have no data (in the specified interval) or are
permanently zero are ignored by default. To include them into the
calculations use **--respect-zero**.

For additional parameters call

```
<SUMO_HOME>/tools/detector/flowrouter.py --help
```

!!! caution
    flowrouter.py is under continuous development. If it fails to deliver the expected results, try using the [latest development version](../Downloads.md#sumo_-_latest_development_version).

## Input files

The traffic flow file is described in the corresponding [dfrouter documentation](../Demand/Routes_from_Observation_Points.md#computing_flows).

As detector file input you can either use

- The detector file as described in the [dfrouter documentation](../Demand/Routes_from_Observation_Points.md#computing_detector_types)
- A detector file with types as [generated by dfrouter](../Demand/Routes_from_Observation_Points.md#computing_detector_types)
- a file with [induction loop definitions](../Simulation/Output/Induction_Loops_Detectors_(E1).md)

When loading a detector file without `type` information or setting the option **--revalidate-detectors**, all network edges will be re-classified as *sources*, *sinks* or
*in-between*.

- any edge without incoming edges will be marked as a source
- any edge without outgoing edges will be marked as a sink
- any edge that is neither source or sink is *in-between*

## Generating vehicles with additional parameters

With the option **--params** {{DT_STR}}, additional parameters can be given to the generated
vehicles (note, usage of the quoting characters).

```
<SUMO_HOME>/tools/detector/flowrouter.py -n input_net.net.xml --params="departLane=\"best\" departSpeed=\"max\" type=\"myType""
```

This would insert the vehicle with high speed on a reasonable lane. The
vehicles would be defined with type *myType* (which could also be the
name of a typeDistribution).

## Ambiguity

In many cases, the solutions for a given input is not unique. It is often the case, that a large proportion of the solution space contains "implausible" (i.e. looped / detour) routes. Some strategies for mitigation are described below. In some cases it may be better to use the [routeSampler tool instead](../Demand/Routes_from_Observation_Points.md#chosing_the_right_tool).

### Distribution among candidate successors

By setting the option **--limit** {{DT_INT}}, the flow is assigned in multiple iterations. This can increase running time but causes
flows to be distributed more evenly so that all routes are used in
proportion to the incoming and outgoing flows (similar to the behavir of 
[dfrouter](../dfrouter.md)).


### Restricting generated routes

With the option **--flow-restrictions** {{DT_FILE}}, flow restriction for routes may be given. Each line in the input file takes the form:

```
<FLOW1> <EDGE1> <EDGE2> ... <EDGEk>
```

This specifies the maximum flow for a route that consists of the given
edges. Alternatively, the flow for a single edge can be restricted with an input line:

```
<FLOW1> <EDGE1>
```

The tool [implausibleRoutes.py](Routes.md#implausibleroutespy) can be used to generate restrictions for routes that are implausible according to a configurable heuristic.

# flowFromRoutes.py

This script does the reverse of flowrouter.py and
[dfrouter](../dfrouter.md) in generating a traffic counts for
detectors from a route or flow file. It's main purpse  It can also be used to compare the
input counts with the outputs of flowrouter.py and
[dfrouter](../dfrouter.md). Example:

```
<SUMO_HOME>/tools/detector/flowFromRoutes.py -d detectors.xml -r routes.xml -e flows.xml
```

# flowFromEdgeData

This script is similar to [flowFromRoutes](#flowFromRoutes). It generates traffic counts for detectors but uses [edgeData files](../Simulation/Output/Lane-_or_Edge-based_Traffic_Measures.md) as input instead of routes.
It requires the use of an input flow file and then performs a comparison between input flows and edgdata flows
```
<SUMO_HOME>/tools/detector/flowFromEdgeData.py -d detectors.xml -e edgedata.xml -f flows.txt
```


# edgeDataFromFlow.py

This script converts detector flow files to into edgeData format (i.e. to be used by [routeSampler.py](Turns.md#routesamplerpy))
Example:
```
<SUMO_HOME>/tools/detector/edgeDataFromFlow.py -d input_detectors.det.xml -f input_flows.txt -o edgedata.xml 
```

# filterFlows.py

Filters a flow file by detector ids and time range
```
<SUMO_HOME>/tools/detector/edgeDataFromFlow.py -d det1,det2 -f input_flows.txt -b 3600 -e 7200 -o output_flows.txt
```

# mapDetectors.py

Given a file `det.csv` of the following form
```
id;lat;lon
det1;52.432559;13.496612;1000
det2;52.432373;13.496142;500
```

It can be turned into a file with detectors with:
```
<SUMO_HOME>/tools/detector/mapDetectors.py -n net.net.xml -d  det.csv -o det.add.xml
```
