package firehose

import (
	"bytes"
	"fmt"
	"strings"
	"sync/atomic"
	"testing"

	"github.com/VictoriaMetrics/VictoriaMetrics/lib/prompbmarshal"
	"github.com/VictoriaMetrics/VictoriaMetrics/lib/promutils"
	"github.com/VictoriaMetrics/VictoriaMetrics/lib/protoparser/opentelemetry/stream"
)

func TestProcessRequestBody(t *testing.T) {
	data := []byte(`{"requestId":"94885867-d282-4110-a3c5-4af3f9ce1150","timestamp":1709217414040,"records":[{"data":"oB0KnR0KuwEKFwoOY2xvdWQucHJvdmlkZXISBQoDYXdzCiIKEGNsb3VkLmFjY291bnQuaWQSDgoMNjc3NDM1ODkwNTk4ChsKDGNsb3VkLnJlZ2lvbhILCgl1cy1lYXN0LTEKXwoQYXdzLmV4cG9ydGVyLmFybhJLCklhcm46YXdzOmNsb3Vkd2F0Y2g6dXMtZWFzdC0xOjY3NzQzNTg5MDU5ODptZXRyaWMtc3RyZWFtL2N1c3RvbV9lYnNfbWV0cmljEtwbErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMDg2Y2ZjMTA4NTQwOGUwZGMRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMDZkMDc4YWIxYmNjMDBlYzMRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMGJkMTU0NjVkNjljMjNhOWERABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMDM3YjdmMjg3ZWViNzlmYTkRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMGJlZWY0OWRlMGQ2OGYzMmMRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMDMzMTMzMjU5ZGY2N2JiOTcRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMDljZDEwMGIxNTliYjI1ZDYRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMGU4MzgzMTkyMWQ3MzU1NjMRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMDIzZWQzMjZhZTg2MDA1NWERABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMGJjYTQ2ZTAyMjQzZjdhNTQRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMGZmOGMzODkzNDNmZTZlMGYRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMDYyZDE4MmE5ZTNkNjk3MWYRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErEBCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAQp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMDAzMDUyZjNiMzlkNjI3OWMRABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/ErECCiNhbWF6b25hd3MuY29tL0FXUy9FQlMvVm9sdW1lUmVhZE9wcxoHe0NvdW50fVqAAgp+ChQKCU5hbWVzcGFjZRIHQVdTL0VCUwobCgpNZXRyaWNOYW1lEg1Wb2x1bWVSZWFkT3BzCiEKCFZvbHVtZUlkEhV2b2wtMGM0NDEwOTk3YmUyMzEzNDARABjlKfhbuBcZAHAsIgZcuBchAQAAAAAAAAAyADIJCQAAAAAAAPA/Cn4KFAoJTmFtZXNwYWNlEgdBV1MvRUJTChsKCk1ldHJpY05hbWUSDVZvbHVtZVJlYWRPcHMKIQoIVm9sdW1lSWQSFXZvbC0wYzQ0MTA5OTdiZTIzMTM0MBEAwJ0x6lu4FxkAGOUp+Fu4FyEBAAAAAAAAADIAMgkJAAAAAAAA8D8SsQEKI2FtYXpvbmF3cy5jb20vQVdTL0VCUy9Wb2x1bWVSZWFkT3BzGgd7Q291bnR9WoABCn4KFAoJTmFtZXNwYWNlEgdBV1MvRUJTChsKCk1ldHJpY05hbWUSDVZvbHVtZVJlYWRPcHMKIQoIVm9sdW1lSWQSFXZvbC0wM2VlNzM1Y2VkZjFmNDZjZREAGOUp+Fu4FxkAcCwiBly4FyEBAAAAAAAAADIAMgkJAAAAAAAA8D8SsQEKI2FtYXpvbmF3cy5jb20vQVdTL0VCUy9Wb2x1bWVSZWFkT3BzGgd7Q291bnR9WoABCn4KFAoJTmFtZXNwYWNlEgdBV1MvRUJTChsKCk1ldHJpY05hbWUSDVZvbHVtZVJlYWRPcHMKIQoIVm9sdW1lSWQSFXZvbC0wOThmZmY4ZTc5ZmJkMmVmNxEAGOUp+Fu4FxkAcCwiBly4FyEBAAAAAAAAADIAMgkJAAAAAAAA8D8SsQEKI2FtYXpvbmF3cy5jb20vQVdTL0VCUy9Wb2x1bWVSZWFkT3BzGgd7Q291bnR9WoABCn4KFAoJTmFtZXNwYWNlEgdBV1MvRUJTChsKCk1ldHJpY05hbWUSDVZvbHVtZVJlYWRPcHMKIQoIVm9sdW1lSWQSFXZvbC0wMWY2ZjNhMzEwNGM4ZWRjYREAGOUp+Fu4FxkAcCwiBly4FyEBAAAAAAAAADIAMgkJAAAAAAAA8D8SsQEKI2FtYXpvbmF3cy5jb20vQVdTL0VCUy9Wb2x1bWVSZWFkT3BzGgd7Q291bnR9WoABCn4KFAoJTmFtZXNwYWNlEgdBV1MvRUJTChsKCk1ldHJpY05hbWUSDVZvbHVtZVJlYWRPcHMKIQoIVm9sdW1lSWQSFXZvbC0wN2E3NmViNGJhMDVlODNkMREAwJ0x6lu4FxkAGOUp+Fu4FyEBAAAAAAAAADIAMgkJAAAAAAAA8D8SsQEKI2FtYXpvbmF3cy5jb20vQVdTL0VCUy9Wb2x1bWVSZWFkT3BzGgd7Q291bnR9WoABCn4KFAoJTmFtZXNwYWNlEgdBV1MvRUJTChsKCk1ldHJpY05hbWUSDVZvbHVtZVJlYWRPcHMKIQoIVm9sdW1lSWQSFXZvbC0wMTFiYjVjNWJkZDc2ZDk2NREAGOUp+Fu4FxkAcCwiBly4FyEBAAAAAAAAADIAMgkJAAAAAAAA8D8="},{"data":"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"}]}`)

	sExpected := `{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217180000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217180000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217180000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217180000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217180000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217180000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217180000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217180000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217240000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_sum",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps_count",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric"} 1 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="0"} 0 1709217300000
{__name__="amazonaws.com/AWS/EBS/VolumeReadOps",cloud.provider="aws",cloud.account.id="677435890598",cloud.region="us-east-1",aws.exporter.arn="arn:aws:cloudwatch:us-east-1:677435890598:metric-stream/custom_ebs_metric",quantile="1"} 0 1709217300000
`
	var callbackCalls atomic.Uint64
	err := stream.ParseStream(bytes.NewReader(data), false, ProcessRequestBody, func(tss []prompbmarshal.TimeSeries) error {
		callbackCalls.Add(1)
		s := formatTimeseries(tss)
		if s != sExpected {
			t.Fatalf("unexpected timeseries; got\n%s\nwant\n%s", s, sExpected)
		}
		return nil
	})
	if err != nil {
		t.Fatalf("unexpected error: %s", err)
	}
	if n := callbackCalls.Load(); n != 1 {
		t.Fatalf("unexpected number of callback calls; got %d; want 1", n)
	}
}

func formatTimeseries(tss []prompbmarshal.TimeSeries) string {
	var labels promutils.Labels
	var a []string
	for _, ts := range tss {
		labels.Labels = ts.Labels
		labelsStr := labels.String()
		for _, sample := range ts.Samples {
			s := fmt.Sprintf("%s %g %d\n", labelsStr, sample.Value, sample.Timestamp)
			a = append(a, s)
		}
	}
	return strings.Join(a, "")
}
